/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.kernel;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelAnalysisModule;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class LttngKernelAnalysisTest {
    private LttngKernelTrace fTrace;
    private KernelAnalysisModule fKernelAnalysisModule;

    @BeforeClass
    public static void setUpClass() {
        Assume.assumeTrue((boolean)CtfTmfTestTrace.KERNEL.exists());
    }

    @Before
    public void setUp() {
        this.fKernelAnalysisModule = new KernelAnalysisModule();
        this.fTrace = new LttngKernelTrace();
        try {
            this.fTrace.initTrace(null, CtfTmfTestTrace.KERNEL.getPath(), CtfTmfEvent.class);
        }
        catch (TmfTraceException e) {
            throw new RuntimeException(e);
        }
    }

    @After
    public void tearDown() {
        this.fTrace.dispose();
        this.fKernelAnalysisModule.dispose();
        this.fTrace = null;
        this.fKernelAnalysisModule = null;
    }

    @Test
    public void testAnalysisExecution() {
        this.fKernelAnalysisModule.setId("test");
        LttngKernelTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        try {
            Assert.assertTrue((boolean)this.fKernelAnalysisModule.setTrace((ITmfTrace)trace));
        }
        catch (TmfAnalysisException e) {
            Assert.fail((String)e.getMessage());
        }
        ITmfStateSystem ss = this.fKernelAnalysisModule.getStateSystem();
        Assert.assertNull((Object)ss);
        Assert.assertTrue((boolean)TmfTestHelper.executeAnalysis((IAnalysisModule)this.fKernelAnalysisModule));
        ss = this.fKernelAnalysisModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        List quarks = ss.getQuarks(new String[]{"*"});
        Assert.assertFalse((boolean)quarks.isEmpty());
    }

    @Test
    public void testCanExecute() {
        Assert.assertNotNull((Object)this.fTrace);
        Assert.assertTrue((boolean)this.fKernelAnalysisModule.canExecute((ITmfTrace)this.fTrace));
        Assume.assumeTrue((boolean)CtfTmfTestTrace.CYG_PROFILE.exists());
        Throwable throwable = null;
        Object var2_3 = null;
        try (CtfTmfTrace trace = CtfTmfTestTrace.CYG_PROFILE.getTrace();){
            Assert.assertTrue((boolean)this.fKernelAnalysisModule.canExecute((ITmfTrace)trace));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    @Ignore
    public void testGetAnalysisRequirements() {
        Iterable requirements = this.fKernelAnalysisModule.getAnalysisRequirements();
        Assert.assertNotNull((Object)requirements);
        TmfAnalysisRequirement eventReq = null;
        TmfAnalysisRequirement domainReq = null;
        int numberOfRequirement = 0;
        for (TmfAnalysisRequirement requirement : requirements) {
            ++numberOfRequirement;
            if (requirement.getType().equals("event")) {
                eventReq = requirement;
                continue;
            }
            if (!requirement.getType().equals("domain")) continue;
            domainReq = requirement;
        }
        Assert.assertNotNull(eventReq);
        Assert.assertNotNull(domainReq);
        Assert.assertEquals((long)2L, (long)numberOfRequirement);
        Assert.assertEquals((long)1L, (long)domainReq.getValues().size());
        for (String domain : domainReq.getValues()) {
            Assert.assertEquals((Object)"KERNEL", (Object)domain);
        }
        ImmutableSet expectedEvents = ImmutableSet.of();
        Assert.assertEquals((long)0L, (long)eventReq.getValues().size());
        for (String event : eventReq.getValues()) {
            Assert.assertTrue((String)("Unexpected event " + event), (boolean)expectedEvents.contains(event));
        }
    }
}

