/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.vm;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelAnalysisModule;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.module.VirtualMachineCpuAnalysis;
import org.eclipse.tracecompass.lttng2.lttng.kernel.core.tests.shared.vm.VmTestExperiment;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class VirtualMachineAnalysisTest {
    private static void verifyStateIntervals(String testId, List<ITmfStateInterval> intervals, int[] expectedStarts, ITmfStateValue[] expectedValues) {
        int expectedCount = expectedStarts.length - 1;
        Assert.assertEquals((String)(String.valueOf(testId) + ": Interval count"), (long)expectedCount, (long)intervals.size());
        int i = 0;
        while (i < expectedCount) {
            ITmfStateInterval interval = intervals.get(i);
            Assert.assertEquals((String)(String.valueOf(testId) + ": Start time of interval " + i), (long)expectedStarts[i], (long)interval.getStartTime());
            long actualEnd = i == expectedCount - 1 ? expectedStarts[i + 1] : expectedStarts[i + 1] - 1;
            Assert.assertEquals((String)(String.valueOf(testId) + ": End time of interval " + i), (long)actualEnd, (long)interval.getEndTime());
            Assert.assertEquals((String)(String.valueOf(testId) + ": Expected value of interval " + i), (Object)expectedValues[i], (Object)interval.getStateValue());
            ++i;
        }
    }

    private static void verifyIntervalsWithMask(String testId, Collection<ITmfStateInterval> intervals, int[] expectedStarts, int[] expectedEnds, ITmfStateValue[] expectedValues, int mask) {
        int expectedCount = expectedStarts.length - 1;
        Assert.assertEquals((String)(String.valueOf(testId) + ": Interval count"), (long)expectedCount, (long)intervals.size());
        int i = 0;
        for (ITmfStateInterval interval : intervals) {
            Assert.assertEquals((String)(String.valueOf(testId) + ": Start time of interval " + i), (long)expectedStarts[i], (long)interval.getStartTime());
            Assert.assertEquals((String)(String.valueOf(testId) + ": End time of interval " + i), (long)expectedEnds[i], (long)interval.getEndTime());
            Assert.assertEquals((String)(String.valueOf(testId) + ": Expected value of interval " + i), (long)(expectedValues[i].unboxInt() & mask), (long)(interval.getStateValue().unboxInt() & mask));
            ++i;
        }
    }

    @Test
    public void testStubTracesOneQemuKvm() {
        KernelAnalysisModule module2;
        Assume.assumeTrue((boolean)VmTestExperiment.ONE_QEMUKVM.exists());
        TmfExperiment experiment = VmTestExperiment.ONE_QEMUKVM.getExperiment(true);
        for (ITmfTrace trace : experiment.getTraces()) {
            ((TmfTrace)trace).traceOpened(new TmfTraceOpenedSignal((Object)this, trace, null));
        }
        for (ITmfTrace trace : experiment.getTraces()) {
            trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)trace);
            for (KernelAnalysisModule module2 : TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, KernelAnalysisModule.class)) {
                module2.schedule();
                module2.waitForCompletion();
            }
        }
        experiment.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)experiment, null));
        VirtualMachineCpuAnalysis module3 = null;
        module2 = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)experiment, VirtualMachineCpuAnalysis.class).iterator();
        if (module2.hasNext()) {
            VirtualMachineCpuAnalysis mod;
            module3 = mod = (VirtualMachineCpuAnalysis)module2.next();
        }
        Assert.assertNotNull(module3);
        module3.schedule();
        if (!module3.waitForCompletion()) {
            Assert.fail((String)"Module did not complete properly");
        }
        try {
            try {
                ITmfStateSystem ss = module3.getStateSystem();
                Assert.assertNotNull((Object)ss);
                int vmQuark = ss.getQuarkAbsolute(new String[]{"Virtual Machines"});
                List guestQuarks = ss.getSubAttributes(vmQuark, false);
                Assert.assertEquals((String)"Number of guests", (long)1L, (long)guestQuarks.size());
                List vcpuQuarks = ss.getSubAttributes(((Integer)guestQuarks.get(0)).intValue(), false);
                Assert.assertEquals((String)"Number of virtual CPUs", (long)1L, (long)vcpuQuarks.size());
                Integer statusQuark = ss.getQuarkRelative(((Integer)vcpuQuarks.get(0)).intValue(), new String[]{"Status"});
                List intervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)statusQuark, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
                int[] expectedStarts = new int[]{1, 60, 75, 95, 100, 150, 155, 195, 210, 245, 260, 295, 300, 350, 355, 375};
                ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.nullValue(), TmfStateValue.newValueInt((int)0), TmfStateValue.newValueInt((int)2), TmfStateValue.newValueInt((int)130), TmfStateValue.newValueInt((int)386), TmfStateValue.newValueInt((int)130), TmfStateValue.newValueInt((int)2), TmfStateValue.newValueInt((int)130), TmfStateValue.newValueInt((int)2), TmfStateValue.newValueInt((int)130), TmfStateValue.newValueInt((int)2), TmfStateValue.newValueInt((int)130), TmfStateValue.newValueInt((int)386), TmfStateValue.newValueInt((int)130), TmfStateValue.newValueInt((int)2)};
                VirtualMachineAnalysisTest.verifyStateIntervals("Virtual CPU", intervals, expectedStarts, expectedValues);
                int[] expectedStartsT130 = new int[]{10, 35, 75, 175, 195, 225, 275, 295, 300, 350, 375};
                int[] expectedEndsT130 = new int[]{34, 74, 174, 224, 209, 274, 374, 299, 349, 354, 375};
                ITmfStateValue[] expectedValuesT30 = new ITmfStateValue[]{TmfStateValue.newValueInt((int)1), TmfStateValue.newValueInt((int)2), TmfStateValue.newValueInt((int)1), TmfStateValue.newValueInt((int)2), TmfStateValue.newValueInt((int)256), TmfStateValue.newValueInt((int)1), TmfStateValue.newValueInt((int)2), TmfStateValue.newValueInt((int)256), TmfStateValue.newValueInt((int)256), TmfStateValue.newValueInt((int)256), TmfStateValue.newValueInt((int)2)};
                int[] expectedStartsT131 = new int[]{10, 35, 75, 95, 100, 150, 175, 225, 245, 275, 375};
                int[] expectedEndsT131 = new int[]{34, 74, 174, 99, 149, 154, 224, 274, 259, 374, 375};
                ITmfStateValue[] expectedValuesT31 = new ITmfStateValue[]{TmfStateValue.newValueInt((int)2), TmfStateValue.newValueInt((int)1), TmfStateValue.newValueInt((int)2), TmfStateValue.newValueInt((int)256), TmfStateValue.newValueInt((int)256), TmfStateValue.newValueInt((int)256), TmfStateValue.newValueInt((int)1), TmfStateValue.newValueInt((int)2), TmfStateValue.newValueInt((int)256), TmfStateValue.newValueInt((int)1), TmfStateValue.newValueInt((int)2)};
                Multimap threadIntervals = module3.getUpdatedThreadIntervals(((Integer)guestQuarks.get(0)).intValue(), ss.getStartTime(), ss.getCurrentEndTime(), 1L, (IProgressMonitor)new NullProgressMonitor());
                VirtualMachineAnalysisTest.verifyIntervalsWithMask("Thread 130", threadIntervals.get((Object)130), expectedStartsT130, expectedEndsT130, expectedValuesT30, 256);
                VirtualMachineAnalysisTest.verifyIntervalsWithMask("Thread 131", threadIntervals.get((Object)131), expectedStartsT131, expectedEndsT131, expectedValuesT31, 256);
            }
            catch (AttributeNotFoundException | StateSystemDisposedException e) {
                Assert.fail((String)e.getMessage());
                experiment.dispose();
            }
        }
        finally {
            experiment.dispose();
        }
    }
}

