/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.analysis;

import java.io.File;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelAnalysisModule;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class AnalysisBenchmark {
    private static final String TEST_ID = "org.eclipse.linuxtools#LTTng kernel analysis";
    private static final int LOOP_COUNT = 25;

    @Test
    public void testTrace2() {
        AnalysisBenchmark.runTest(CtfTmfTestTrace.TRACE2, "Trace2");
    }

    private static void runTest(CtfTmfTestTrace testTrace, String testName) {
        Assume.assumeTrue((boolean)testTrace.exists());
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter("org.eclipse.linuxtools#LTTng kernel analysis#" + testName);
        perf.tagAsSummary(pm, "LTTng Kernel Analysis: " + testName, Dimension.CPU_TIME);
        if (testTrace == CtfTmfTestTrace.TRACE2) {
            perf.tagAsGlobalSummary(pm, "LTTng Kernel Analysis: " + testName, Dimension.CPU_TIME);
        }
        int i = 0;
        while (i < 25) {
            block20: {
                KernelAnalysisModule module = null;
                try {
                    try {
                        Throwable throwable = null;
                        Object var7_9 = null;
                        try (LttngKernelTrace trace = new LttngKernelTrace();){
                            module = new KernelAnalysisModule();
                            module.setId("test");
                            trace.initTrace(null, testTrace.getPath(), CtfTmfEvent.class);
                            module.setTrace((ITmfTrace)trace);
                            pm.start();
                            TmfTestHelper.executeAnalysis((IAnalysisModule)module);
                            pm.stop();
                            File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
                            File[] fileArray = suppDir.listFiles();
                            int n = fileArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File file = fileArray[n2];
                                file.delete();
                                ++n2;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (TmfAnalysisException | TmfTraceException e) {
                        Assert.fail((String)e.getMessage());
                        if (module != null) {
                            module.dispose();
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (module != null) {
                        module.dispose();
                    }
                    throw throwable;
                }
                if (module != null) {
                    module.dispose();
                }
            }
            ++i;
        }
        pm.commit();
        testTrace.dispose();
    }
}

