/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.model.VirtualMachine;

public class VirtualCPU {
    private static final Table<VirtualMachine, Long, VirtualCPU> VIRTUAL_CPU_TABLE = (Table)NonNullUtils.checkNotNull((Object)HashBasedTable.create());
    private final VirtualMachine fVm;
    private final Long fCpuId;

    public static synchronized VirtualCPU getVirtualCPU(VirtualMachine vm, Long cpu) {
        VirtualCPU ht = (VirtualCPU)VIRTUAL_CPU_TABLE.get((Object)vm, (Object)cpu);
        if (ht == null) {
            ht = new VirtualCPU(vm, cpu);
            VIRTUAL_CPU_TABLE.put((Object)vm, (Object)cpu, (Object)ht);
        }
        return ht;
    }

    private VirtualCPU(VirtualMachine vm, Long cpu) {
        this.fVm = vm;
        this.fCpuId = cpu;
    }

    public Long getCpuId() {
        return this.fCpuId;
    }

    public VirtualMachine getVm() {
        return this.fVm;
    }

    public String toString() {
        return "VirtualCPU: [" + this.fVm + ',' + this.fCpuId + ']';
    }
}

