/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StateSystemUtilsTest {
    private static final long START_TIME = 1000L;
    @NonNull
    private static final String DUMMY_STRING = "test";
    private ITmfStateSystemBuilder fStateSystem;

    @Before
    public void setupStateSystem() {
        try {
            IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)DUMMY_STRING, (long)1000L);
            this.fStateSystem = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
            int quark = this.fStateSystem.getQuarkAbsoluteAndAdd(new String[]{DUMMY_STRING});
            this.fStateSystem.modifyAttribute(1200L, (ITmfStateValue)TmfStateValue.newValueInt((int)10), quark);
            this.fStateSystem.modifyAttribute(1500L, (ITmfStateValue)TmfStateValue.newValueInt((int)20), quark);
            this.fStateSystem.closeHistory(2000L);
        }
        catch (AttributeNotFoundException | StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() {
        this.fStateSystem.dispose();
    }

    @Test
    public void testQueryUntilNonNullValue() {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        Assert.assertNotNull((Object)ss);
        try {
            int quark = ss.getQuarkAbsolute(new String[]{DUMMY_STRING});
            Assert.assertNull((Object)StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)quark, (long)0L, (long)999L));
            Assert.assertNull((Object)StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)quark, (long)2001L, (long)5000L));
            Assert.assertNull((Object)StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)quark, (long)1000L, (long)1199L));
            ITmfStateInterval interval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)quark, (long)1000L, (long)1300L);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((Object)ITmfStateValue.Type.INTEGER, (Object)interval.getStateValue().getType());
            Assert.assertEquals((long)10L, (long)interval.getStateValue().unboxInt());
            interval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)quark, (long)800L, (long)2500L);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((Object)ITmfStateValue.Type.INTEGER, (Object)interval.getStateValue().getType());
            Assert.assertEquals((long)10L, (long)interval.getStateValue().unboxInt());
            interval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)quark, (long)1300L, (long)1800L);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((Object)ITmfStateValue.Type.INTEGER, (Object)interval.getStateValue().getType());
            Assert.assertEquals((long)10L, (long)interval.getStateValue().unboxInt());
            interval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)quark, (long)1500L, (long)1800L);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((Object)ITmfStateValue.Type.INTEGER, (Object)interval.getStateValue().getType());
            Assert.assertEquals((long)20L, (long)interval.getStateValue().unboxInt());
            interval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)quark, (long)1800L, (long)2500L);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((Object)ITmfStateValue.Type.INTEGER, (Object)interval.getStateValue().getType());
            Assert.assertEquals((long)20L, (long)interval.getStateValue().unboxInt());
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

