/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.Activator;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public enum TmfXmlTestFiles {
    VALID_FILE("test_xml_files/test_valid/test_valid.xml"),
    INVALID_FILE("test_xml_files/test_invalid/test_invalid.xml"),
    ATTRIBUTE_FILE("test_xml_files/test_valid/test_attributes.xml");

    private final String fPath;

    private TmfXmlTestFiles(String file) {
        this.fPath = file;
    }

    public IPath getPath() {
        IPath absPath = Activator.getAbsolutePath(new Path(this.fPath));
        if (absPath == null) {
            Assert.fail((String)("Cannot find file path for '" + this.fPath + "'"));
        }
        return absPath;
    }

    public File getFile() {
        return this.getPath().toFile();
    }

    public Document getXmlDocument() {
        Document doc = null;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(this.getFile());
            doc.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException e) {
            Assert.fail((String)"Xml document parse exception");
        }
        catch (SAXException e) {
            Assert.fail((String)"Exception parsing xml file");
        }
        catch (IOException e) {
            Assert.fail((String)"File io exception");
        }
        return doc;
    }
}

