/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.Activator;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;

public class XmlUtilsTest {
    private static final Path PATH_INVALID = new Path("test_xml_files/test_invalid");
    private static final Path PATH_VALID = new Path("test_xml_files/test_valid");
    @NonNull
    private static final String ANALYSIS_ID = "kernel.linux.sp";

    @After
    public void emptyXmlFolder() {
        File fFolder = XmlUtils.getXmlFilesPath().toFile();
        if (!fFolder.isDirectory() || !fFolder.exists()) {
            return;
        }
        File[] fileArray = fFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File xmlFile = fileArray[n2];
            xmlFile.delete();
            ++n2;
        }
    }

    @Test
    public void testXmlPath() {
        IPath xmlPath = XmlUtils.getXmlFilesPath();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath workspacePath = workspace.getRoot().getRawLocation();
        workspacePath = workspacePath.addTrailingSeparator().append(".metadata").addTrailingSeparator().append(".plugins").addTrailingSeparator().append("org.eclipse.tracecompass.tmf.analysis.xml.core").addTrailingSeparator().append("xml_files");
        Assert.assertEquals((Object)xmlPath, (Object)workspacePath);
    }

    @Test
    public void testXmlValidate() {
        IStatus status;
        File testXmlFile = TmfXmlTestFiles.VALID_FILE.getFile();
        if (testXmlFile == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        if (!(status = XmlUtils.xmlValidate((File)testXmlFile)).isOK()) {
            Assert.fail((String)status.getMessage());
        }
        if ((testXmlFile = TmfXmlTestFiles.INVALID_FILE.getFile()) == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        Assert.assertFalse((boolean)XmlUtils.xmlValidate((File)testXmlFile).isOK());
    }

    @Test
    public void testXmlValidateInvalid() {
        IPath path = Activator.getAbsolutePath(PATH_INVALID);
        File file = path.toFile();
        File[] invalidFiles = file.listFiles();
        Assert.assertTrue((invalidFiles.length > 0 ? 1 : 0) != 0);
        File[] fileArray = invalidFiles;
        int n = invalidFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            Assert.assertFalse((String)("File " + f.getName()), (boolean)XmlUtils.xmlValidate((File)f).isOK());
            ++n2;
        }
    }

    @Test
    public void testXmlValidateValid() {
        IPath path = Activator.getAbsolutePath(PATH_VALID);
        File file = path.toFile();
        File[] validFiles = file.listFiles();
        Assert.assertTrue((validFiles.length > 0 ? 1 : 0) != 0);
        File[] fileArray = validFiles;
        int n = validFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            Assert.assertTrue((String)("File " + f.getName()), (boolean)XmlUtils.xmlValidate((File)f).isOK());
            ++n2;
        }
    }

    @Test
    public void testXmlAddFile() {
        IPath xmlPath = XmlUtils.getXmlFilesPath().addTrailingSeparator().append("test_valid.xml");
        File destFile = xmlPath.toFile();
        Assert.assertFalse((boolean)destFile.exists());
        File testXmlFile = TmfXmlTestFiles.VALID_FILE.getFile();
        if (testXmlFile == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        XmlUtils.addXmlFile((File)testXmlFile);
        Assert.assertTrue((boolean)destFile.exists());
    }

    @Test
    public void testGetElementInFile() {
        File testXmlFile = TmfXmlTestFiles.VALID_FILE.getFile();
        if (testXmlFile == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        if (testXmlFile == null) {
            return;
        }
        Element analysis = XmlUtils.getElementInFile((String)testXmlFile.getAbsolutePath(), (String)"stateProvider", (String)ANALYSIS_ID);
        Assert.assertNotNull((Object)analysis);
    }

    @Test
    public void testGetChildElements() {
        File testXmlFile = TmfXmlTestFiles.VALID_FILE.getFile();
        if (testXmlFile == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        if (testXmlFile == null) {
            return;
        }
        Element analysis = XmlUtils.getElementInFile((String)testXmlFile.getAbsolutePath(), (String)"stateProvider", (String)ANALYSIS_ID);
        List values = XmlUtils.getChildElements((Element)analysis, (String)"location");
        Assert.assertEquals((long)5L, (long)values.size());
        Element aLocation = (Element)values.get(0);
        List attributes = XmlUtils.getChildElements((Element)aLocation, (String)"stateAttribute");
        Assert.assertEquals((long)2L, (long)attributes.size());
        values = XmlUtils.getChildElements((Element)analysis, (String)"head");
        Assert.assertEquals((long)1L, (long)values.size());
        Element head = (Element)values.get(0);
        values = XmlUtils.getChildElements((Element)head);
        Assert.assertEquals((long)2L, (long)values.size());
    }
}

