/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stateprovider;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.tracecompass.tmf.analysis.xml.core.stateprovider.XmlStateSystemModule;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StateProviderModuleTest {
    private static String ANALYSIS_ID = "kernel.linux.sp";
    private static String ANALYSIS_NAME = "Xml kernel State System";
    private XmlStateSystemModule fModule;

    @Test
    public void testModuleConstruction() {
        Document doc = TmfXmlTestFiles.VALID_FILE.getXmlDocument();
        Assert.assertNotNull((Object)doc);
        NodeList stateproviderNodes = doc.getElementsByTagName("stateProvider");
        Assert.assertTrue((stateproviderNodes.getLength() > 0 ? 1 : 0) != 0);
        Element node = (Element)stateproviderNodes.item(0);
        this.fModule = new XmlStateSystemModule();
        String moduleId = node.getAttribute("id");
        Assert.assertNotNull((Object)moduleId);
        this.fModule.setId(moduleId);
        Assert.assertEquals((Object)ANALYSIS_ID, (Object)this.fModule.getId());
        this.fModule.setXmlFile(TmfXmlTestFiles.VALID_FILE.getPath());
        Assert.assertEquals((Object)ANALYSIS_NAME, (Object)this.fModule.getName());
    }

    @Test
    public void testModuleExecution() {
        Assume.assumeTrue((boolean)CtfTmfTestTrace.KERNEL.exists());
        Document doc = TmfXmlTestFiles.VALID_FILE.getXmlDocument();
        Assert.assertNotNull((Object)doc);
        NodeList stateproviderNodes = doc.getElementsByTagName("stateProvider");
        Element node = (Element)stateproviderNodes.item(0);
        this.fModule = new XmlStateSystemModule();
        String moduleId = node.getAttribute("id");
        Assert.assertNotNull((Object)moduleId);
        this.fModule.setId(moduleId);
        this.fModule.setXmlFile(TmfXmlTestFiles.VALID_FILE.getPath());
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (CtfTmfTrace trace = CtfTmfTestTrace.KERNEL.getTrace();){
                this.fModule.setTrace((ITmfTrace)trace);
                this.fModule.schedule();
                Assert.assertTrue((boolean)this.fModule.waitForCompletion((IProgressMonitor)new NullProgressMonitor()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TmfAnalysisException e) {
            Assert.fail((String)("Cannot set trace " + e.getMessage()));
        }
    }
}

