/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stateprovider;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.analysis.xml.core.stateprovider.XmlStateSystemModule;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StateProviderTest {
    private ITmfTrace fTrace;
    private XmlStateSystemModule fModule;

    @Before
    public void setupTest() {
        Assume.assumeTrue((boolean)CtfTmfTestTrace.KERNEL.exists());
        CtfTmfTrace trace = CtfTmfTestTrace.KERNEL.getTrace();
        this.fTrace = trace;
        Document doc = TmfXmlTestFiles.VALID_FILE.getXmlDocument();
        Assert.assertNotNull((Object)doc);
        NodeList stateproviderNodes = doc.getElementsByTagName("stateProvider");
        Element node = (Element)stateproviderNodes.item(0);
        this.fModule = new XmlStateSystemModule();
        String moduleId = node.getAttribute("id");
        Assert.assertNotNull((Object)moduleId);
        this.fModule.setId(moduleId);
        this.fModule.setXmlFile((IPath)new Path(TmfXmlTestFiles.VALID_FILE.getFile().getAbsolutePath()));
        try {
            this.fModule.setTrace((ITmfTrace)trace);
            this.fModule.schedule();
        }
        catch (TmfAnalysisException e) {
            Assert.fail((String)("Cannot set trace " + e.getMessage()));
        }
    }

    @After
    public void cleanupTest() {
        this.fTrace.dispose();
    }

    @Test
    public void testStateSystem() {
        Assert.assertTrue((boolean)this.fModule.waitForCompletion((IProgressMonitor)new NullProgressMonitor()));
        ITmfStateSystem ss = this.fModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        List quarks = ss.getQuarks(new String[]{"*"});
        Assert.assertFalse((boolean)quarks.isEmpty());
    }
}

