/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.ui.tests.module;

import com.google.common.collect.Multimap;
import java.io.File;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.ui.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XmlAnalysisModuleSourceTest {
    private static final String SS_MODULE = "kernel.linux.sp";
    private static final String BUILTIN_MODULE = "test.builtin.sp";

    private static void emptyXmlFolder() {
        File fFolder = XmlUtils.getXmlFilesPath().toFile();
        if (!fFolder.isDirectory() || !fFolder.exists()) {
            return;
        }
        File[] fileArray = fFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File xmlFile = fileArray[n2];
            xmlFile.delete();
            ++n2;
        }
        XmlAnalysisModuleSource.notifyModuleChange();
    }

    @Before
    public void setUp() {
        XmlAnalysisModuleSourceTest.emptyXmlFolder();
    }

    @After
    public void cleanUp() {
        XmlAnalysisModuleSourceTest.emptyXmlFolder();
    }

    @Test
    public void testPopulateModules() {
        XmlAnalysisModuleSource module = new XmlAnalysisModuleSource();
        Iterable modules = module.getAnalysisModules();
        Assert.assertFalse((String)"Module present", (boolean)XmlAnalysisModuleSourceTest.findModule(modules, SS_MODULE));
        Assert.assertTrue((String)"builtin module present", (boolean)XmlAnalysisModuleSourceTest.findModule(modules, BUILTIN_MODULE));
        File testXmlFile = TmfXmlTestFiles.VALID_FILE.getFile();
        if (testXmlFile == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        XmlUtils.addXmlFile((File)testXmlFile);
        XmlAnalysisModuleSource.notifyModuleChange();
        modules = module.getAnalysisModules();
        Assert.assertTrue((String)"Modules available from source", (boolean)modules.iterator().hasNext());
        Assert.assertTrue((String)"Module present after add file", (boolean)XmlAnalysisModuleSourceTest.findModule(modules, SS_MODULE));
        Assert.assertTrue((String)"Builtin module present after add file", (boolean)XmlAnalysisModuleSourceTest.findModule(modules, BUILTIN_MODULE));
    }

    private static boolean findModule(Iterable<IAnalysisModuleHelper> modules, String moduleName) {
        for (IAnalysisModuleHelper helper : modules) {
            if (!moduleName.equals(helper.getId())) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testPopulateModulesWithAnalysisManager() {
        TmfAnalysisManager.initialize();
        Multimap modules = TmfAnalysisManager.getAnalysisModules();
        Assert.assertFalse((boolean)XmlAnalysisModuleSourceTest.findModule(modules.values(), SS_MODULE));
        Assert.assertTrue((boolean)XmlAnalysisModuleSourceTest.findModule(modules.values(), BUILTIN_MODULE));
        File testXmlFile = TmfXmlTestFiles.VALID_FILE.getFile();
        if (testXmlFile == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        XmlUtils.addXmlFile((File)testXmlFile);
        XmlAnalysisModuleSource.notifyModuleChange();
        modules = TmfAnalysisManager.getAnalysisModules();
        Assert.assertTrue((boolean)XmlAnalysisModuleSourceTest.findModule(modules.values(), SS_MODULE));
        Assert.assertTrue((boolean)XmlAnalysisModuleSourceTest.findModule(modules.values(), BUILTIN_MODULE));
    }
}

