/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.ui.module;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.Activator;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.ui.module.TmfXmlViewOutput;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisOutput;
import org.eclipse.tracecompass.tmf.core.analysis.ITmfNewAnalysisModuleListener;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TmfXmlAnalysisOutputSource
implements ITmfNewAnalysisModuleListener {
    public static final String DATA_SEPARATOR = ";;;";

    public void moduleCreated(IAnalysisModule module) {
        IPath pathToFiles = XmlUtils.getXmlFilesPath();
        File fFolder = pathToFiles.toFile();
        if (!fFolder.isDirectory() || !fFolder.exists()) {
            return;
        }
        File[] fileArray = fFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File xmlFile = fileArray[n2];
            if (XmlUtils.xmlValidate((File)xmlFile).isOK()) {
                try {
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(xmlFile);
                    doc.getDocumentElement().normalize();
                    if (module instanceof TmfStateSystemAnalysisModule) {
                        ViewType[] viewTypeArray = ViewType.values();
                        int n3 = viewTypeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ViewType viewType = viewTypeArray[n4];
                            NodeList ssViewNodes = doc.getElementsByTagName(viewType.getXmlElem());
                            int i = 0;
                            while (i < ssViewNodes.getLength()) {
                                Element node = (Element)ssViewNodes.item(i);
                                List headNodes = XmlUtils.getChildElements((Element)node, (String)"head");
                                if (headNodes.size() == 1) {
                                    List analysisNodes = XmlUtils.getChildElements((Element)((Element)headNodes.get(0)), (String)"analysis");
                                    for (Element analysis : analysisNodes) {
                                        String analysisId = analysis.getAttribute("id");
                                        if (!analysisId.equals(module.getId())) continue;
                                        String viewId = viewType.getViewId();
                                        TmfXmlViewOutput output = new TmfXmlViewOutput(viewId, viewType);
                                        output.setOutputProperty("xmlOutputData", String.valueOf(node.getAttribute("id")) + DATA_SEPARATOR + xmlFile.getAbsolutePath(), false);
                                        module.registerOutput((IAnalysisOutput)output);
                                    }
                                }
                                ++i;
                            }
                            ++n4;
                        }
                    }
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    Activator.logError("Error opening XML file", e);
                }
            }
            ++n2;
        }
    }

    public static enum ViewType {
        TIME_GRAPH_VIEW("timeGraphView", "org.eclipse.linuxtools.tmf.analysis.xml.ui.views.timegraph"),
        XY_VIEW("xyView", "org.eclipse.linuxtools.internal.tmf.analysis.xml.ui.views.xyview");

        @NonNull
        private final String fXmlElem;
        private final String fViewId;

        private ViewType(String xmlElem, String viewId) {
            this.fXmlElem = xmlElem;
            this.fViewId = viewId;
        }

        @NonNull
        public String getXmlElem() {
            return this.fXmlElem;
        }

        private String getViewId() {
            return this.fViewId;
        }
    }
}

