/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.analysis;

import com.google.common.collect.Multimap;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestAnalysisParameterProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AnalysisParameterProviderTest {
    private static IAnalysisModuleHelper getModuleHelper(@NonNull String moduleId) {
        Multimap helpers = TmfAnalysisManager.getAnalysisModules();
        Assert.assertEquals((long)1L, (long)helpers.get((Object)moduleId).size());
        return (IAnalysisModuleHelper)helpers.get((Object)moduleId).iterator().next();
    }

    @Before
    public void setup() {
        TmfAnalysisManager.registerParameterProvider((String)"org.eclipse.linuxtools.tmf.core.tests.analysis.test", TestAnalysisParameterProvider.class);
    }

    @After
    public void cleanupTrace() {
        TmfTestTrace.A_TEST_10K.dispose();
    }

    @Test
    public void testProviderTmfTrace() {
        ITmfTrace trace = TmfTestTrace.A_TEST_10K.getTrace();
        IAnalysisModuleHelper helper = AnalysisParameterProviderTest.getModuleHelper("org.eclipse.linuxtools.tmf.core.tests.analysis.test");
        Assert.assertNotNull((Object)helper);
        IAnalysisModule module = null;
        try {
            try {
                module = helper.newModule(trace);
                Assert.assertNotNull((Object)module);
                Assert.assertEquals((Object)10, (Object)module.getParameter("test"));
                List providers = TmfAnalysisManager.getParameterProviders((IAnalysisModule)module, (ITmfTrace)trace);
                Assert.assertEquals((long)1L, (long)providers.size());
                TestAnalysisParameterProvider provider = (TestAnalysisParameterProvider)((Object)providers.get(0));
                provider.setValue(5);
                Assert.assertEquals((Object)5, (Object)module.getParameter("test"));
            }
            catch (TmfAnalysisException e) {
                Assert.fail((String)e.getMessage());
                if (module != null) {
                    module.dispose();
                }
            }
        }
        finally {
            if (module != null) {
                module.dispose();
            }
        }
    }
}

