/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.analysis;

import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisRequirementProvider;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisRequirementHelper;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.AnalysisModuleTestHelper;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.AnalysisRequirementFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AnalysisRequirementHelperTest {
    private AnalysisModuleTestHelper fTestModuleHelper;
    private AnalysisModuleTestHelper fTestModuleHelper2;

    @Before
    public void setUpTest() {
        this.fTestModuleHelper = new AnalysisModuleTestHelper(AnalysisModuleTestHelper.moduleStubEnum.TEST);
        this.fTestModuleHelper2 = new AnalysisModuleTestHelper(AnalysisModuleTestHelper.moduleStubEnum.TEST2);
    }

    @Test
    public void testGetRequirementValues() {
        String type = "car";
        Set values = TmfAnalysisRequirementHelper.getRequirementValues((IAnalysisRequirementProvider)this.fTestModuleHelper, (String)type);
        Assert.assertEquals((long)AnalysisRequirementFactory.REQUIREMENT_VALUES_1.size(), (long)values.size());
        type = "factory";
        values = TmfAnalysisRequirementHelper.getRequirementValues((IAnalysisRequirementProvider)this.fTestModuleHelper, (String)type);
        Assert.assertTrue((boolean)values.isEmpty());
    }

    @Test
    public void testGetRequirementValuesWithLevel() {
        String type = "factory";
        Set values = TmfAnalysisRequirementHelper.getRequirementValues((IAnalysisRequirementProvider)this.fTestModuleHelper2, (String)type, (TmfAnalysisRequirement.ValuePriorityLevel)TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        Assert.assertEquals((long)3L, (long)values.size());
        values = TmfAnalysisRequirementHelper.getRequirementValues((IAnalysisRequirementProvider)this.fTestModuleHelper2, (String)type, (TmfAnalysisRequirement.ValuePriorityLevel)TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL);
        Assert.assertEquals((long)2L, (long)values.size());
        type = "car";
        values = TmfAnalysisRequirementHelper.getRequirementValues((IAnalysisRequirementProvider)this.fTestModuleHelper2, (String)type, (TmfAnalysisRequirement.ValuePriorityLevel)TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        Assert.assertTrue((boolean)values.isEmpty());
    }

    @Test
    public void testGetRequirementValuesMap() {
        HashSet<AnalysisModuleTestHelper> providers = new HashSet<AnalysisModuleTestHelper>();
        providers.add(this.fTestModuleHelper2);
        providers.add(this.fTestModuleHelper);
        SetMultimap valuesByType = TmfAnalysisRequirementHelper.getRequirementValuesMap(providers);
        Assert.assertFalse((boolean)valuesByType.isEmpty());
        Assert.assertEquals((long)3L, (long)valuesByType.keySet().size());
        Collection values = valuesByType.get((Object)"car");
        Assert.assertEquals((long)4L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("value1"));
        Assert.assertTrue((boolean)values.contains("value2"));
        Assert.assertTrue((boolean)values.contains("value3"));
        Assert.assertTrue((boolean)values.contains("value5"));
        values = valuesByType.get((Object)"factory");
        Assert.assertEquals((long)5L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("value1"));
        Assert.assertTrue((boolean)values.contains("value2"));
        Assert.assertTrue((boolean)values.contains("value3"));
        Assert.assertTrue((boolean)values.contains("value4"));
        Assert.assertTrue((boolean)values.contains("value5"));
        values = valuesByType.get((Object)"code");
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("value3"));
        Assert.assertTrue((boolean)values.contains("value4"));
        Assert.assertTrue((boolean)values.contains("value5"));
    }

    @Test
    public void testGetRequirementValuesMapWithLevel() {
        HashSet<AnalysisModuleTestHelper> providers = new HashSet<AnalysisModuleTestHelper>();
        providers.add(this.fTestModuleHelper2);
        providers.add(this.fTestModuleHelper);
        SetMultimap valuesByType = TmfAnalysisRequirementHelper.getRequirementValuesMap(providers, (TmfAnalysisRequirement.ValuePriorityLevel)TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL);
        Assert.assertTrue((!valuesByType.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)valuesByType.keySet().size());
        Collection values = valuesByType.get((Object)"car");
        Assert.assertTrue((boolean)values.isEmpty());
        values = valuesByType.get((Object)"factory");
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("value2"));
        Assert.assertTrue((boolean)values.contains("value4"));
        values = valuesByType.get((Object)"code");
        Assert.assertTrue((boolean)values.isEmpty());
        valuesByType = TmfAnalysisRequirementHelper.getRequirementValuesMap(providers, (TmfAnalysisRequirement.ValuePriorityLevel)TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        Assert.assertTrue((!valuesByType.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)valuesByType.keySet().size());
        values = valuesByType.get((Object)"car");
        Assert.assertEquals((long)4L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("value1"));
        Assert.assertTrue((boolean)values.contains("value2"));
        Assert.assertTrue((boolean)values.contains("value3"));
        Assert.assertTrue((boolean)values.contains("value5"));
        values = valuesByType.get((Object)"factory");
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("value1"));
        Assert.assertTrue((boolean)values.contains("value3"));
        Assert.assertTrue((boolean)values.contains("value5"));
        values = valuesByType.get((Object)"code");
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("value3"));
        Assert.assertTrue((boolean)values.contains("value4"));
        Assert.assertTrue((boolean)values.contains("value5"));
    }
}

