/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.filter;

import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfContentFieldAspect;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterCompareNode;
import org.eclipse.tracecompass.tmf.core.tests.filter.TmfFilterTreeNodeTest;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfNanoTimestamp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfFilterCompareNodeTest
extends TmfFilterTreeNodeTest {
    private ITmfEventField[] fFields1 = new ITmfEventField[]{new TmfEventField("field", (Object)"1", null)};
    private ITmfEventField[] fFields2 = new ITmfEventField[]{new TmfEventField("field", (Object)"5", null)};
    private ITmfEventField[] fFields3 = new ITmfEventField[]{new TmfEventField("field", (Object)"11", null)};
    private ITmfEventField fContent1 = new TmfEventField(":root:", null, this.fFields1);
    private ITmfEventField fContent2 = new TmfEventField(":root:", null, this.fFields2);
    private ITmfEventField fContent3 = new TmfEventField(":root:", null, this.fFields3);
    private TmfEvent fEvent1 = new TmfEvent(TRACE, 0L, (ITmfTimestamp)new TmfNanoTimestamp(1L), EVENT_TYPE, this.fContent1);
    private TmfEvent fEvent2 = new TmfEvent(TRACE, 1L, (ITmfTimestamp)new TmfNanoTimestamp(2L), EVENT_TYPE, this.fContent2);
    private TmfEvent fEvent3 = new TmfEvent(TRACE, 2L, (ITmfTimestamp)new TmfNanoTimestamp(3L), EVENT_TYPE, this.fContent3);
    private TmfFilterCompareNode fFilter;

    @Before
    public void createFilter() {
        this.fFilter = new TmfFilterCompareNode(null);
        this.fFilterNode = this.fFilter;
    }

    @Test
    public void testMatchesNum() {
        this.fFilter.setEventAspect((ITmfEventAspect)new TmfContentFieldAspect("field", new String[]{"field"}));
        this.fFilter.setType(TmfFilterCompareNode.Type.NUM);
        this.fFilter.setValue("5");
        this.fFilter.setResult(-1);
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent3));
        this.fFilter.setResult(0);
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent3));
        this.fFilter.setResult(1);
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent3));
        this.fFilter.setNot(true);
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent3));
    }

    @Test
    public void testMatchesAlpha() {
        this.fFilter.setEventAspect((ITmfEventAspect)new TmfContentFieldAspect("field", new String[]{"field"}));
        this.fFilter.setType(TmfFilterCompareNode.Type.ALPHA);
        this.fFilter.setValue("5");
        this.fFilter.setResult(-1);
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent3));
        this.fFilter.setResult(0);
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent3));
        this.fFilter.setResult(1);
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent3));
        this.fFilter.setNot(true);
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent3));
    }

    @Test
    public void testMatchesTimestamp() {
        this.fFilter.setEventAspect(ITmfEventAspect.BaseAspects.TIMESTAMP);
        this.fFilter.setType(TmfFilterCompareNode.Type.TIMESTAMP);
        this.fFilter.setValue("0.000000002");
        this.fFilter.setResult(-1);
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent3));
        this.fFilter.setResult(0);
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent3));
        this.fFilter.setResult(1);
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent3));
        this.fFilter.setNot(true);
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent3));
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((String)"getName()", (Object)"COMPARE", (Object)this.fFilter.getNodeName());
    }

    @Test
    public void testGetValidChildren() {
        Assert.assertArrayEquals((String)"getValidChildren()", (Object[])new String[0], (Object[])this.fFilter.getValidChildren().toArray());
    }
}

