/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.statesystem;

import java.util.concurrent.TimeUnit;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class StateSystemAnalysisModuleTest {
    @Rule
    public TestRule globalTimeout = new Timeout(20L, TimeUnit.SECONDS);
    public static final String MODULE_SS = "org.eclipse.linuxtools.tmf.core.tests.analysis.sstest";
    private TmfStateSystemAnalysisModule module;

    @Before
    public void setupTraces() {
        TmfTraceStub trace = (TmfTraceStub)TmfTestTrace.A_TEST_10K.getTrace();
        TmfSignalManager.deregister((Object)((Object)trace));
        trace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        this.module = (TmfStateSystemAnalysisModule)trace.getAnalysisModule(MODULE_SS);
    }

    @After
    public void cleanupTraces() {
        TmfTestTrace.A_TEST_10K.dispose();
    }

    @Test
    public void testSsModule() {
        ITmfStateSystem ss = this.module.getStateSystem();
        Assert.assertNull((Object)ss);
        this.module.schedule();
        if (this.module.waitForCompletion()) {
            ss = this.module.getStateSystem();
            Assert.assertNotNull((Object)ss);
        } else {
            Assert.fail((String)"Module did not complete properly");
        }
    }

    @Test
    public void testInitialization() {
        Assert.assertNull((Object)this.module.getStateSystem());
        this.module.schedule();
        this.module.waitForInitialization();
        Assert.assertNotNull((Object)this.module.getStateSystem());
    }
}

