/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.synchronization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.SyncAlgorithmFullyIncremental;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventDependency;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.synchronization.SynchronizationAlgorithm;
import org.eclipse.tracecompass.tmf.core.synchronization.SynchronizationAlgorithmFactory;
import org.eclipse.tracecompass.tmf.core.synchronization.TimestampTransformFactory;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.event.TmfSyncEventStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SyncTest {
    private TmfTraceStub t1;
    private TmfTraceStub t2;
    private Collection<ITmfTrace> fTraces;

    @Before
    public void init() {
        this.t1 = new TmfTraceStub();
        this.t1.init("t1");
        this.t2 = new TmfTraceStub();
        this.t2.init("t2");
        LinkedList<ITmfTrace> traces = new LinkedList<ITmfTrace>();
        traces.add((ITmfTrace)this.t1);
        traces.add((ITmfTrace)this.t2);
        this.fTraces = traces;
    }

    @Test
    public void testFullyIncremental() {
        SynchronizationAlgorithm syncAlgo = SynchronizationAlgorithmFactory.getFullyIncrementalAlgorithm();
        syncAlgo.init(this.fTraces);
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.ABSENT, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t2, 1L, (ITmfTrace)this.t1, 1L);
        Assert.assertEquals((Object)"SyncAlgorithmFullyIncremental [Between t1 and t2 [ alpha 1 beta 0 ]]", (Object)syncAlgo.toString());
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.INCOMPLETE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 1L, (ITmfTrace)this.t2, 3L);
        Assert.assertEquals((Object)"SyncAlgorithmFullyIncremental [Between t1 and t2 [ alpha 1 beta 0 ]]", (Object)syncAlgo.toString());
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.INCOMPLETE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t2, 2L, (ITmfTrace)this.t1, 3L);
        Assert.assertEquals((Object)"SyncAlgorithmFullyIncremental [Between t1 and t2 [ alpha 1 beta 0.5 ]]", (Object)syncAlgo.toString());
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.APPROXIMATE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 3L, (ITmfTrace)this.t2, 5L);
        Assert.assertEquals((Object)"SyncAlgorithmFullyIncremental [Between t1 and t2 [ alpha 0.75 beta 1.25 ]]", (Object)syncAlgo.toString());
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.ACCURATE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 4L, (ITmfTrace)this.t2, 8L);
        Assert.assertEquals((Object)"SyncAlgorithmFullyIncremental [Between t1 and t2 [ alpha 0.75 beta 1.25 ]]", (Object)syncAlgo.toString());
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.ACCURATE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t2, 4L, (ITmfTrace)this.t1, 5L);
        Assert.assertEquals((Object)"SyncAlgorithmFullyIncremental [Between t1 and t2 [ alpha 1.125 beta 0.875 ]]", (Object)syncAlgo.toString());
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.ACCURATE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t2, 4L, (ITmfTrace)this.t1, 6L);
        Assert.assertEquals((Object)"SyncAlgorithmFullyIncremental [Between t1 and t2 [ alpha 1.125 beta 0.875 ]]", (Object)syncAlgo.toString());
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.ACCURATE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 6L, (ITmfTrace)this.t2, 7L);
        Assert.assertEquals((Object)"SyncAlgorithmFullyIncremental [Between t1 and t2 [ alpha 0.725 beta 1.275 ]]", (Object)syncAlgo.toString());
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.ACCURATE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        ITmfTimestampTransform tt2 = syncAlgo.getTimestampTransform((ITmfTrace)this.t2);
        ITmfTimestampTransform tt1 = syncAlgo.getTimestampTransform((ITmfTrace)this.t1);
        Assert.assertEquals((Object)syncAlgo.getTimestampTransform(this.t1.getHostId()), (Object)tt1);
        Assert.assertEquals((Object)TimestampTransformFactory.getDefaultTransform(), (Object)tt1);
        Assert.assertEquals((Object)syncAlgo.getTimestampTransform(this.t2.getHostId()), (Object)tt2);
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 7L, (ITmfTrace)this.t2, 4L);
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t2, 7L, (ITmfTrace)this.t1, 3L);
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.FAIL, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
    }

    @Test
    public void testOneHull() {
        SynchronizationAlgorithm syncAlgo = SynchronizationAlgorithmFactory.getFullyIncrementalAlgorithm();
        syncAlgo.init(this.fTraces);
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.ABSENT, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 1L, (ITmfTrace)this.t2, 3L);
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.INCOMPLETE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 2L, (ITmfTrace)this.t2, 5L);
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.INCOMPLETE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 3L, (ITmfTrace)this.t2, 5L);
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.INCOMPLETE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 4L, (ITmfTrace)this.t2, 7L);
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.INCOMPLETE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        Assert.assertEquals((Object)"SyncAlgorithmFullyIncremental [Between t1 and t2 [ alpha 1 beta 0 ]]", (Object)syncAlgo.toString());
    }

    @Test
    public void testDisjoint() {
        SynchronizationAlgorithm syncAlgo = SynchronizationAlgorithmFactory.getFullyIncrementalAlgorithm();
        syncAlgo.init(this.fTraces);
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.ABSENT, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 1L, (ITmfTrace)this.t2, 3L);
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.INCOMPLETE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 2L, (ITmfTrace)this.t2, 5L);
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.INCOMPLETE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 3L, (ITmfTrace)this.t2, 5L);
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.INCOMPLETE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 4L, (ITmfTrace)this.t2, 7L);
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.INCOMPLETE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        Assert.assertEquals((Object)"SyncAlgorithmFullyIncremental [Between t1 and t2 [ alpha 1 beta 0 ]]", (Object)syncAlgo.toString());
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t2, 7L, (ITmfTrace)this.t1, 6L);
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.APPROXIMATE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t2, 8L, (ITmfTrace)this.t1, 6L);
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.APPROXIMATE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t2, 10L, (ITmfTrace)this.t1, 8L);
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.APPROXIMATE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        Assert.assertEquals((Object)"SyncAlgorithmFullyIncremental [Between t1 and t2 [ alpha 1 beta 2.5 ]]", (Object)syncAlgo.toString());
    }

    private static void addSyncMatch(SynchronizationAlgorithm algo, ITmfTrace sender, long sendTs, ITmfTrace receiver, long receiveTs) {
        algo.addMatch(new TmfEventDependency((ITmfEvent)new TmfSyncEventStub(sender, (ITmfTimestamp)new TmfTimestamp(sendTs)), (ITmfEvent)new TmfSyncEventStub(receiver, (ITmfTimestamp)new TmfTimestamp(receiveTs))));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testFullyIncrementalSerialization() {
        SynchronizationAlgorithm deserialAlgo;
        ITmfTimestampTransform tt1;
        ITmfTimestampTransform tt2;
        block33: {
            Throwable throwable;
            String filePath;
            block31: {
                SynchronizationAlgorithm syncAlgo = SynchronizationAlgorithmFactory.getFullyIncrementalAlgorithm();
                syncAlgo.init(this.fTraces);
                SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t2, 1L, (ITmfTrace)this.t1, 1L);
                SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 1L, (ITmfTrace)this.t2, 3L);
                SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t2, 2L, (ITmfTrace)this.t1, 3L);
                SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 3L, (ITmfTrace)this.t2, 5L);
                SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 4L, (ITmfTrace)this.t2, 8L);
                SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t2, 4L, (ITmfTrace)this.t1, 5L);
                SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t2, 4L, (ITmfTrace)this.t1, 6L);
                SyncTest.addSyncMatch(syncAlgo, (ITmfTrace)this.t1, 6L, (ITmfTrace)this.t2, 7L);
                tt2 = syncAlgo.getTimestampTransform((ITmfTrace)this.t2);
                tt1 = syncAlgo.getTimestampTransform((ITmfTrace)this.t1);
                Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.ACCURATE, (Object)syncAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
                Assert.assertEquals((Object)syncAlgo.getTimestampTransform(this.t1.getHostId()), (Object)tt1);
                Assert.assertEquals((Object)TimestampTransformFactory.getDefaultTransform(), (Object)tt1);
                Assert.assertEquals((Object)syncAlgo.getTimestampTransform(this.t2.getHostId()), (Object)tt2);
                filePath = null;
                try {
                    File temp = File.createTempFile("serialSyncAlgo", ".tmp");
                    filePath = temp.getAbsolutePath();
                }
                catch (IOException e) {
                    Assert.fail((String)"Could not create temporary file for serialization");
                }
                Assert.assertNotNull(filePath);
                try {
                    Throwable e = null;
                    throwable = null;
                    try {
                        FileOutputStream fileOut = new FileOutputStream(filePath);
                        try {
                            try (ObjectOutputStream out = new ObjectOutputStream(fileOut);){
                                out.writeObject(syncAlgo);
                            }
                            if (fileOut == null) break block31;
                        }
                        catch (Throwable throwable2) {
                            if (e == null) {
                                e = throwable2;
                            } else if (e != throwable2) {
                                e.addSuppressed(throwable2);
                            }
                            if (fileOut == null) throw e;
                            fileOut.close();
                            throw e;
                        }
                        fileOut.close();
                    }
                    catch (Throwable throwable3) {
                        if (e == null) {
                            e = throwable3;
                            throw e;
                        }
                        if (e == throwable3) throw e;
                        e.addSuppressed(throwable3);
                        throw e;
                    }
                }
                catch (IOException e) {
                    Assert.fail((String)("Error serializing the synchronization algorithm " + e.getMessage()));
                }
            }
            deserialAlgo = null;
            try {
                throwable = null;
                Object var7_14 = null;
                try {
                    FileInputStream fileIn = new FileInputStream(filePath);
                    try {
                        try (ObjectInputStream in = new ObjectInputStream(fileIn);){
                            deserialAlgo = (SynchronizationAlgorithm)in.readObject();
                        }
                        if (fileIn == null) break block33;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        if (fileIn == null) throw throwable;
                        fileIn.close();
                        throw throwable;
                    }
                    fileIn.close();
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                        throw throwable;
                    }
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                    throw throwable;
                }
            }
            catch (IOException | ClassNotFoundException e) {
                Assert.fail((String)("Error de-serializing the synchronization algorithm " + e.getMessage()));
            }
        }
        Assert.assertNotNull(deserialAlgo);
        Assert.assertTrue((boolean)(deserialAlgo instanceof SyncAlgorithmFullyIncremental));
        Assert.assertEquals((Object)SynchronizationAlgorithm.SyncQuality.ACCURATE, (Object)deserialAlgo.getSynchronizationQuality((ITmfTrace)this.t1, (ITmfTrace)this.t2));
        Assert.assertEquals((Object)tt1, (Object)deserialAlgo.getTimestampTransform((ITmfTrace)this.t1));
        Assert.assertEquals((Object)tt2, (Object)deserialAlgo.getTimestampTransform((ITmfTrace)this.t2));
    }
}

