/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace.indexer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Random;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.BTree;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.BTreeCheckpointVisitor;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.FlatArray;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.IBTreeVisitor;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.Assert;

public class AllBench {
    private static final boolean reportProgress = true;
    private static ArrayList<ArrayList<Integer>> nums;
    private TmfTraceStub fTrace;
    private File file = new File("index.idx");
    static int BTREE_DEGREE;

    static {
        BTREE_DEGREE = 10;
    }

    private void setUp() {
        this.fTrace = new TmfTraceStub();
        if (this.file.exists()) {
            this.file.delete();
        }
    }

    private void tearDown() {
        this.fTrace.dispose();
        this.fTrace = null;
        if (this.file.exists()) {
            this.file.delete();
        }
    }

    private static void generateDataFile(ArrayList<Integer> list, int checkpointsNums) throws IOException {
        File randomDataFile = new File("data" + checkpointsNums);
        Throwable throwable = null;
        Object var4_5 = null;
        try (RandomAccessFile f = new RandomAccessFile(randomDataFile, "rw");){
            if (randomDataFile.exists()) {
                int i = 0;
                while (i < checkpointsNums) {
                    Random rand = new Random();
                    int nextInt = rand.nextInt(checkpointsNums);
                    list.add(nextInt);
                    f.writeInt(nextInt);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < checkpointsNums) {
                    list.add(f.readInt());
                    ++i;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws IOException {
        int[] checkpointsNums = new int[]{5000, 50000, 500000, 1000000};
        nums = new ArrayList(checkpointsNums.length);
        System.out.println("DEGREE: " + BTREE_DEGREE);
        AllBench b = new AllBench();
        b.setUp();
        int i = 0;
        while (i < checkpointsNums.length) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            AllBench.generateDataFile(list, checkpointsNums[i]);
            nums.add(list);
            System.out.println("*** " + checkpointsNums[i] + " checkpoints ***\n");
            b.benchIt(list);
            ++i;
        }
        b.tearDown();
    }

    private void benchIt(ArrayList<Integer> list) {
        System.out.println("Testing BTree\n");
        this.testInsertAlot(list);
        System.out.println("Testing Array\n");
        this.testInsertAlotArray(list);
    }

    private void testInsertAlot(ArrayList<Integer> list2) {
        int checkpointsNum = list2.size();
        this.writeCheckpoints(checkpointsNum);
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < checkpointsNum) {
            list.add(i);
            ++i;
        }
        this.readCheckpoints(checkpointsNum, list, false);
        this.readCheckpoints(checkpointsNum, list2, true);
        this.file.delete();
        System.out.println();
    }

    private void testInsertAlotArray(ArrayList<Integer> list2) {
        int checkpointsNum = list2.size();
        this.writeCheckpointsArray(checkpointsNum);
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < checkpointsNum) {
            list.add(i);
            ++i;
        }
        this.readCheckpointsArray(checkpointsNum, list, false);
        this.readCheckpointsArray(checkpointsNum, list2, true);
        this.file.delete();
        System.out.println();
    }

    private void writeCheckpoints(int checkpointsNum) {
        int REPEAT = 10;
        long time = 0L;
        int j = 0;
        while (j < REPEAT) {
            long old = System.currentTimeMillis();
            BTree bTree = new BTree(BTREE_DEGREE, this.file, (ITmfPersistentlyIndexable)this.fTrace);
            int i = 0;
            while (i < checkpointsNum) {
                TmfCheckpoint checkpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp((long)(12345 + i)), (ITmfLocation)new TmfLongLocation(123456L + (long)i), (long)i);
                bTree.insert((ITmfCheckpoint)checkpoint);
                ++i;
            }
            time += System.currentTimeMillis() - old;
            bTree.setIndexComplete();
            bTree.dispose();
            if (j != REPEAT - 1) {
                this.file.delete();
            }
            System.out.print(".");
            ++j;
        }
        System.out.println("Write time average: " + (float)time / (float)REPEAT);
    }

    private void writeCheckpointsArray(int checkpointsNum) {
        int REPEAT = 10;
        long time = 0L;
        int j = 0;
        while (j < REPEAT) {
            long old = System.currentTimeMillis();
            FlatArray array = new FlatArray(this.file, (ITmfPersistentlyIndexable)this.fTrace);
            int i = 0;
            while (i < checkpointsNum) {
                TmfCheckpoint checkpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp((long)(12345 + i)), (ITmfLocation)new TmfLongLocation(123456L + (long)i), (long)i);
                array.insert((ITmfCheckpoint)checkpoint);
                ++i;
            }
            time += System.currentTimeMillis() - old;
            array.setIndexComplete();
            array.dispose();
            if (j != REPEAT - 1) {
                this.file.delete();
            }
            System.out.print(".");
            ++j;
        }
        System.out.println("Write time average: " + (float)time / (float)REPEAT);
    }

    private void readCheckpoints(int checkpointsNum, ArrayList<Integer> list, boolean random) {
        int REPEAT = 10;
        long time = 0L;
        long cacheMisses = 0L;
        int j = 0;
        while (j < REPEAT) {
            long old = System.currentTimeMillis();
            BTree bTree = new BTree(BTREE_DEGREE, this.file, (ITmfPersistentlyIndexable)this.fTrace);
            int i = 0;
            while (i < checkpointsNum) {
                Integer randomCheckpoint = list.get(i);
                TmfCheckpoint checkpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp((long)(12345 + randomCheckpoint)), (ITmfLocation)new TmfLongLocation(123456L + (long)randomCheckpoint.intValue()), 0L);
                BTreeCheckpointVisitor treeVisitor = new BTreeCheckpointVisitor((ITmfCheckpoint)checkpoint);
                bTree.accept((IBTreeVisitor)treeVisitor);
                Assert.assertEquals((long)randomCheckpoint.intValue(), (long)treeVisitor.getCheckpoint().getCheckpointRank());
                ++i;
            }
            time += System.currentTimeMillis() - old;
            cacheMisses = bTree.getCacheMisses();
            bTree.dispose();
            System.out.print(".");
            ++j;
        }
        System.out.println("Read " + (random ? "(random)" : "(linear)") + "time average: " + (float)time / (float)REPEAT + "            (cache miss: " + cacheMisses + ")");
    }

    private void readCheckpointsArray(int checkpointsNum, ArrayList<Integer> list, boolean random) {
        int REPEAT = 10;
        long time = 0L;
        long cacheMisses = 0L;
        int j = 0;
        while (j < REPEAT) {
            long old = System.currentTimeMillis();
            FlatArray array = new FlatArray(this.file, (ITmfPersistentlyIndexable)this.fTrace);
            int i = 0;
            while (i < checkpointsNum) {
                Integer randomCheckpoint = list.get(i);
                TmfCheckpoint checkpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp((long)(12345 + randomCheckpoint)), (ITmfLocation)new TmfLongLocation(123456L + (long)randomCheckpoint.intValue()), 0L);
                long found = array.binarySearch((ITmfCheckpoint)checkpoint);
                Assert.assertEquals((long)randomCheckpoint.intValue(), (long)found);
                ++i;
            }
            time += System.currentTimeMillis() - old;
            cacheMisses = array.getCacheMisses();
            array.dispose();
            System.out.print(".");
            ++j;
        }
        System.out.println("Read " + (random ? "(random)" : "(linear)") + "time average: " + (float)time / (float)REPEAT + "            (cache miss: " + cacheMisses + ")");
    }
}

