/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace.indexer;

import java.util.ArrayList;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.BTree;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.BTreeCheckpointVisitor;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.IBTreeVisitor;
import org.eclipse.tracecompass.tmf.core.tests.trace.indexer.AbstractCheckpointCollectionTest;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;
import org.junit.Assert;
import org.junit.Test;

public class BTreeTest
extends AbstractCheckpointCollectionTest {
    private final int DEGREE = 15;
    private BTree fBTree;

    protected BTree createCollection() {
        this.fBTree = new BTree(15, this.getFile(), (ITmfPersistentlyIndexable)this.getTrace());
        this.fCheckpointCollection = this.fBTree;
        return this.fBTree;
    }

    @Override
    public boolean isPersistableCollection() {
        return true;
    }

    @Test
    public void testAccept() {
        int i = 0;
        while (i < 50000) {
            TmfCheckpoint checkpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp((long)i), (ITmfLocation)new TmfLongLocation((long)i), 0L);
            this.fBTree.insert((ITmfCheckpoint)checkpoint);
            ++i;
        }
        TmfCheckpoint checkpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp(123L), (ITmfLocation)new TmfLongLocation(123L), 0L);
        class TestVisitor
        implements IBTreeVisitor {
            public int fLastCompare = 0;
            ITmfCheckpoint fFoundCheckpoint;
            private final /* synthetic */ TmfCheckpoint val$checkpoint;

            TestVisitor(TmfCheckpoint tmfCheckpoint) {
                this.val$checkpoint = tmfCheckpoint;
            }

            public int compare(ITmfCheckpoint checkRec) {
                this.fLastCompare = checkRec.compareTo((ITmfCheckpoint)this.val$checkpoint);
                if (this.fLastCompare == 0) {
                    this.fFoundCheckpoint = checkRec;
                }
                return this.fLastCompare;
            }
        }
        TestVisitor t = new TestVisitor(checkpoint);
        this.fBTree.accept((IBTreeVisitor)t);
        Assert.assertEquals((Object)checkpoint, (Object)t.fFoundCheckpoint);
        Assert.assertEquals((long)0L, (long)t.fLastCompare);
    }

    @Test
    public void testInsertAlotCheckEquals() {
        ArrayList<Integer> list = this.insertAlot();
        this.fBTree = this.createCollection();
        int i = 0;
        while (i < 50000) {
            Integer checkpointIndex = list.get(i);
            TmfCheckpoint checkpoint = new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp((long)(12345 + checkpointIndex)), (ITmfLocation)new TmfLongLocation(123456L + (long)checkpointIndex.intValue()), 0L);
            BTreeCheckpointVisitor treeVisitor = new BTreeCheckpointVisitor((ITmfCheckpoint)checkpoint);
            this.fBTree.accept((IBTreeVisitor)treeVisitor);
            Assert.assertEquals((Object)checkpoint, (Object)treeVisitor.getCheckpoint());
            ++i;
        }
    }

    @Override
    @Test
    public void testSetGetSize() {
        Assert.assertEquals((long)0L, (long)this.fBTree.size());
        int expected = 50000;
        int i = 0;
        while (i < expected) {
            this.fBTree.insert((ITmfCheckpoint)new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp(0L), (ITmfLocation)new TmfLongLocation(0L), 0L));
            this.fBTree.setSize(this.fBTree.size() + 1);
            ++i;
        }
        Assert.assertEquals((long)expected, (long)this.fBTree.size());
    }
}

