/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.tests.stubs.analysis;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.AnalysisRequirementFactory;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestAnalysis;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestAnalysis2;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub2;
import org.osgi.framework.Bundle;

public class AnalysisModuleTestHelper
implements IAnalysisModuleHelper {
    private moduleStubEnum fModule;

    public AnalysisModuleTestHelper(moduleStubEnum module) {
        this.fModule = module;
    }

    public String getId() {
        return this.getName();
    }

    public String getName() {
        return (String)NonNullUtils.checkNotNull((Object)this.fModule.name());
    }

    public boolean isAutomatic() {
        return false;
    }

    public boolean appliesToExperiment() {
        return false;
    }

    public String getHelpText() {
        return "";
    }

    public String getHelpText(@NonNull ITmfTrace trace) {
        return "";
    }

    public String getIcon() {
        return "";
    }

    public Bundle getBundle() {
        return Platform.getBundle((String)"org.eclipse.tracecompass.tmf.core.tests");
    }

    public boolean appliesToTraceType(Class<? extends ITmfTrace> traceclass) {
        switch (this.fModule) {
            case TEST: {
                return TmfTraceStub.class.isAssignableFrom(traceclass);
            }
            case TEST2: {
                return TmfTraceStub2.class.isAssignableFrom(traceclass);
            }
        }
        return false;
    }

    public IAnalysisModule newModule(ITmfTrace trace) throws TmfAnalysisException {
        TmfAbstractAnalysisModule module = null;
        switch (this.fModule) {
            case TEST: {
                module = new TestAnalysis();
                module.setName(this.getName());
                module.setId(this.getId());
                module.setAutomatic(this.isAutomatic());
                if (module.setTrace(trace)) break;
                module.dispose();
                module = null;
                break;
            }
            case TEST2: {
                module = new TestAnalysis2();
                module.setName(this.getName());
                module.setId(this.getId());
                module.setAutomatic(this.isAutomatic());
                if (module.setTrace(trace)) break;
                module.dispose();
                module = null;
                break;
            }
        }
        return module;
    }

    public Iterable<Class<? extends ITmfTrace>> getValidTraceTypes() {
        return ImmutableList.of(TmfTraceStub.class, TmfTraceStub2.class);
    }

    public Iterable<TmfAnalysisRequirement> getAnalysisRequirements() {
        switch (this.fModule) {
            case TEST: {
                return ImmutableList.of((Object)AnalysisRequirementFactory.REQUIREMENT_1, (Object)AnalysisRequirementFactory.REQUIREMENT_3);
            }
            case TEST2: {
                return ImmutableList.of((Object)AnalysisRequirementFactory.REQUIREMENT_2, (Object)AnalysisRequirementFactory.REQUIREMENT_3);
            }
        }
        return Collections.EMPTY_SET;
    }

    public static enum moduleStubEnum {
        TEST,
        TEST2;

    }
}

