/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.tests.stubs.analysis;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;

public class TestRequirementAnalysis
extends TmfAbstractAnalysisModule {
    public static final String EVENT_TYPE = "event";
    public static final String FIELD_TYPE = "field";
    public static final String EXIT_SYSCALL = "exit_syscall";
    public static final String SCHED_SWITCH = "sched_switch";
    public static final String SCHED_WAKEUP = "sched_wakeup";
    public static final String PID = "pid";
    public static final String TID = "tid";

    public boolean canExecute(ITmfTrace trace) {
        return TmfTraceStub.class.isAssignableFrom(trace.getClass());
    }

    protected void canceling() {
    }

    protected boolean executeAnalysis(IProgressMonitor monitor) {
        return true;
    }

    public boolean setTrace(ITmfTrace trace) throws TmfAnalysisException {
        return super.setTrace(trace);
    }

    public Iterable<TmfAnalysisRequirement> getAnalysisRequirements() {
        HashMap<String, TmfAnalysisRequirement> requirements = new HashMap<String, TmfAnalysisRequirement>();
        requirements.put(EVENT_TYPE, new TmfAnalysisRequirement(EVENT_TYPE));
        ((TmfAnalysisRequirement)requirements.get(EVENT_TYPE)).addValue(EXIT_SYSCALL, TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        ((TmfAnalysisRequirement)requirements.get(EVENT_TYPE)).addValue(SCHED_SWITCH, TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        ((TmfAnalysisRequirement)requirements.get(EVENT_TYPE)).addValue(SCHED_WAKEUP, TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        requirements.put(FIELD_TYPE, new TmfAnalysisRequirement(FIELD_TYPE));
        ((TmfAnalysisRequirement)requirements.get(FIELD_TYPE)).addValue(PID, TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        ((TmfAnalysisRequirement)requirements.get(FIELD_TYPE)).addValue(TID, TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        Collection<TmfAnalysisRequirement> values = requirements.values();
        return values;
    }
}

