/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.synchronization;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.ITmfTimestampTransformInvertible;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfTimestampTransform;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfTimestampTransformLinear;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.synchronization.TimestampTransformFactory;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfNanoTimestamp;

public class TmfConstantTransform
implements ITmfTimestampTransformInvertible {
    private static final long serialVersionUID = 417299521984404532L;
    private final long fOffset;

    public TmfConstantTransform() {
        this.fOffset = 0L;
    }

    public TmfConstantTransform(long offset) {
        this.fOffset = offset;
    }

    public TmfConstantTransform(@NonNull ITmfTimestamp offset) {
        this(new TmfNanoTimestamp(offset).getValue());
    }

    @Override
    public ITmfTimestamp transform(ITmfTimestamp timestamp) {
        return timestamp.normalize(this.fOffset, -9);
    }

    @Override
    public long transform(long timestamp) {
        return this.fOffset + timestamp;
    }

    @Override
    public ITmfTimestampTransform composeWith(ITmfTimestampTransform composeWith) {
        if (composeWith.equals(TmfTimestampTransform.IDENTITY)) {
            return this;
        }
        if (composeWith instanceof TmfConstantTransform) {
            TmfConstantTransform tct = (TmfConstantTransform)composeWith;
            long offset = this.fOffset + tct.fOffset;
            if (offset == 0L) {
                return TmfTimestampTransform.IDENTITY;
            }
            return new TmfConstantTransform(offset);
        }
        if (composeWith instanceof TmfTimestampTransformLinear) {
            throw new UnsupportedOperationException("Cannot compose a constant and linear transform yet");
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TmfConstantTransform [ offset = ");
        builder.append(this.fOffset);
        builder.append(" ]");
        return builder.toString();
    }

    @Override
    public ITmfTimestampTransform inverse() {
        return TimestampTransformFactory.createWithOffset(-1L * this.fOffset);
    }
}

