/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.trace.indexer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.ICheckpointCollection;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.Messages;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfPersistentlyIndexable;

public abstract class AbstractFileCheckpointCollection
implements ICheckpointCollection {
    private static final int VERSION = 2;
    private static final int SUB_VERSION_NONE = -1;
    protected static final int INT_SIZE = 4;
    protected static final int LONG_SIZE = 8;
    protected static final int MAX_TIME_RANGE_SERIALIZE_SIZE = 1024;
    private ITmfPersistentlyIndexable fTrace;
    private long fCacheMisses = 0L;
    private boolean fCreatedFromScratch;
    private RandomAccessFile fRandomAccessFile;
    private File fFile;
    private final CheckpointCollectionFileHeader fHeader;
    private FileChannel fFileChannel;
    private TmfTimeRange fTimeRange;

    public AbstractFileCheckpointCollection(File file, ITmfPersistentlyIndexable trace) {
        this.fTrace = trace;
        this.fFile = file;
        this.setCreatedFromScratch(!this.fFile.exists());
        CheckpointCollectionFileHeader header = null;
        if (!this.isCreatedFromScratch() && (header = this.tryRestore()) == null) {
            this.fFile.delete();
            this.dispose();
        }
        if (this.isCreatedFromScratch()) {
            header = this.initialize();
        }
        this.fHeader = header;
    }

    protected CheckpointCollectionFileHeader createHeader() {
        return new CheckpointCollectionFileHeader(2);
    }

    protected CheckpointCollectionFileHeader createHeader(RandomAccessFile randomAccessFile) throws IOException {
        return new CheckpointCollectionFileHeader(randomAccessFile);
    }

    protected int getVersion() {
        return 2;
    }

    protected int getSubVersion() {
        return -1;
    }

    private CheckpointCollectionFileHeader initialize() {
        CheckpointCollectionFileHeader header = null;
        try {
            this.fRandomAccessFile = new RandomAccessFile(this.fFile, "rw");
            this.fFileChannel = this.fRandomAccessFile.getChannel();
            header = this.createHeader();
            this.fRandomAccessFile.setLength(header.getSize());
            this.fTimeRange = new TmfTimeRange(new TmfTimestamp(0L), new TmfTimestamp(0L));
        }
        catch (IOException e) {
            Activator.logError(MessageFormat.format(Messages.ErrorOpeningIndex, this.fFile), e);
            return null;
        }
        return header;
    }

    private CheckpointCollectionFileHeader tryRestore() {
        CheckpointCollectionFileHeader header;
        block5: {
            header = null;
            try {
                this.fRandomAccessFile = new RandomAccessFile(this.fFile, "r");
                this.fFileChannel = this.fRandomAccessFile.getChannel();
            }
            catch (FileNotFoundException e) {
                Activator.logError(MessageFormat.format(Messages.ErrorOpeningIndex, this.fFile), e);
                return null;
            }
            try {
                header = this.createHeader(this.fRandomAccessFile);
                if (header.fVersion == 2 && header.getSubVersion() == this.getSubVersion()) break block5;
                return null;
            }
            catch (IOException e) {
                Activator.logError(MessageFormat.format(Messages.IOErrorReadingHeader, this.fFile), e);
                return null;
            }
        }
        this.serializeInTimeRange(header);
        return header;
    }

    private void serializeInTimeRange(CheckpointCollectionFileHeader header) throws IOException {
        ByteBuffer b = ByteBuffer.allocate(1024);
        b.clear();
        this.fFileChannel.read(b, header.fTimeRangeOffset);
        b.flip();
        this.fTimeRange = new TmfTimeRange(new TmfTimestamp(b), new TmfTimestamp(b));
    }

    private void serializeOutTimeRange() throws IOException {
        this.fHeader.fTimeRangeOffset = this.fRandomAccessFile.length();
        ByteBuffer b = ByteBuffer.allocate(1024);
        b.clear();
        new TmfTimestamp(this.fTimeRange.getStartTime()).serialize(b);
        new TmfTimestamp(this.fTimeRange.getEndTime()).serialize(b);
        b.flip();
        this.fFileChannel.write(b, this.fHeader.fTimeRangeOffset);
    }

    @Override
    public void setIndexComplete() {
        try {
            this.serializeOutTimeRange();
            this.fHeader.serialize(this.fRandomAccessFile);
        }
        catch (IOException e) {
            Activator.logError(MessageFormat.format(Messages.IOErrorWritingHeader, this.fFile), e);
        }
    }

    @Override
    public boolean isCreatedFromScratch() {
        return this.fCreatedFromScratch;
    }

    protected void setCreatedFromScratch(boolean isCreatedFromScratch) {
        this.fCreatedFromScratch = isCreatedFromScratch;
    }

    public long getCacheMisses() {
        return this.fCacheMisses;
    }

    protected void incCacheMisses() {
        ++this.fCacheMisses;
    }

    @Override
    public int size() {
        return this.fHeader.fSize;
    }

    @Override
    public void setTimeRange(TmfTimeRange timeRange) {
        this.fTimeRange = timeRange;
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return this.fTimeRange;
    }

    @Override
    public void setNbEvents(long nbEvents) {
        this.fHeader.fNbEvents = nbEvents;
    }

    @Override
    public long getNbEvents() {
        return this.fHeader.fNbEvents;
    }

    protected ITmfPersistentlyIndexable getTrace() {
        return this.fTrace;
    }

    protected RandomAccessFile getRandomAccessFile() {
        return this.fRandomAccessFile;
    }

    protected FileChannel getFileChannel() {
        return this.fRandomAccessFile.getChannel();
    }

    protected File getFile() {
        return this.fFile;
    }

    public CheckpointCollectionFileHeader getHeader() {
        return this.fHeader;
    }

    @Override
    public void delete() {
        this.dispose();
        if (this.fFile.exists()) {
            this.fFile.delete();
        }
    }

    @Override
    public void dispose() {
        try {
            if (this.fRandomAccessFile != null) {
                this.fRandomAccessFile.close();
            }
            this.setCreatedFromScratch(true);
            this.fRandomAccessFile = null;
        }
        catch (IOException e) {
            Activator.logError(MessageFormat.format(Messages.IOErrorClosingIndex, this.fFile), e);
        }
    }

    protected class CheckpointCollectionFileHeader {
        private static final int SIZE = 24;
        protected final int fVersion;
        protected int fSize = 0;
        protected long fTimeRangeOffset;
        protected long fNbEvents;

        public int getSize() {
            return 24;
        }

        public int getSubVersion() {
            return -1;
        }

        public CheckpointCollectionFileHeader(RandomAccessFile randomAccessFile) throws IOException {
            this.fVersion = randomAccessFile.readInt();
            this.fSize = randomAccessFile.readInt();
            this.fNbEvents = randomAccessFile.readLong();
            this.fTimeRangeOffset = randomAccessFile.readLong();
        }

        public CheckpointCollectionFileHeader(int version) {
            this.fVersion = version;
        }

        public void serialize(RandomAccessFile randomAccessFile) throws IOException {
            randomAccessFile.seek(0L);
            randomAccessFile.writeInt(AbstractFileCheckpointCollection.this.getVersion());
            randomAccessFile.writeInt(this.fSize);
            randomAccessFile.writeLong(this.fNbEvents);
            randomAccessFile.writeLong(this.fTimeRangeOffset);
        }
    }
}

