/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.component;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.TmfCoreTracer;
import org.eclipse.tracecompass.tmf.core.component.ITmfComponent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;

public abstract class TmfComponent
implements ITmfComponent {
    @NonNull
    private String fName = "";

    public TmfComponent() {
        this("");
    }

    public void init(String name) {
        String cmpName = name;
        if (cmpName == null) {
            cmpName = "";
        }
        TmfCoreTracer.traceComponent(cmpName, "created");
        this.fName = cmpName;
        TmfSignalManager.register(this);
    }

    public TmfComponent(String name) {
        this.init(name);
    }

    public TmfComponent(TmfComponent other) {
        this.init(other.fName);
    }

    @Override
    @NonNull
    public String getName() {
        return this.fName;
    }

    protected void setName(@NonNull String name) {
        this.fName = name;
    }

    @Override
    public void dispose() {
        TmfSignalManager.deregister(this);
        TmfCoreTracer.traceComponent(this.fName, "disposed");
    }

    @Override
    public void broadcast(TmfSignal signal) {
        TmfSignalManager.dispatchSignal(signal);
    }

    @Override
    public void broadcastAsync(TmfSignal signal) {
        TmfSignalManager.dispatchSignalAsync(signal);
    }
}

