/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event.aspect;

import java.util.Arrays;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;

public class TmfContentFieldAspect
implements ITmfEventAspect {
    private final String fAspectName;
    private final String[] fFieldPath;
    private final String fHelpText;

    public TmfContentFieldAspect(String aspectName, String ... fieldPath) {
        this(aspectName, "", fieldPath);
    }

    private TmfContentFieldAspect(String aspectName, String helpText, String ... fieldPath) {
        this.fAspectName = aspectName;
        this.fFieldPath = (String[])NonNullUtils.checkNotNull((Object)Arrays.copyOf(fieldPath, fieldPath.length));
        this.fHelpText = helpText;
    }

    public static TmfContentFieldAspect create(String aspectName, String helpText, String ... fieldPath) {
        return new TmfContentFieldAspect(aspectName, helpText, fieldPath);
    }

    @Override
    public String getName() {
        return this.fAspectName;
    }

    @Override
    public String getHelpText() {
        return this.fHelpText;
    }

    @Override
    @Nullable
    public Object resolve(ITmfEvent event) {
        ITmfEventField field = event.getContent().getField(this.fFieldPath);
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fAspectName.hashCode();
        result = 31 * result + Arrays.hashCode(this.fFieldPath);
        result = 31 * result + this.fHelpText.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        TmfContentFieldAspect other = (TmfContentFieldAspect)obj;
        if (!this.fAspectName.equals(other.fAspectName)) {
            return false;
        }
        if (!Arrays.equals(this.fFieldPath, other.fFieldPath)) {
            return false;
        }
        return this.fHelpText.equals(other.fHelpText);
    }
}

