/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.synchronization;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.component.TmfComponent;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.synchronization.SynchronizationAlgorithm;
import org.eclipse.tracecompass.tmf.core.synchronization.SynchronizationAlgorithmFactory;
import org.eclipse.tracecompass.tmf.core.synchronization.SynchronizationBackend;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class SynchronizationManager
extends TmfComponent {
    public static SynchronizationAlgorithm synchronizeTraces(File syncFile, Collection<ITmfTrace> traces, boolean doSync) {
        SynchronizationAlgorithm syncAlgo;
        if (doSync) {
            syncAlgo = SynchronizationManager.synchronize(syncFile, traces, SynchronizationAlgorithmFactory.getDefaultAlgorithm());
        } else {
            syncAlgo = SynchronizationManager.openExisting(syncFile);
            if (syncAlgo == null) {
                syncAlgo = SynchronizationAlgorithmFactory.getDefaultAlgorithm();
            }
        }
        return syncAlgo;
    }

    public static SynchronizationAlgorithm synchronizeTraces(File syncFile, Collection<ITmfTrace> traces, SynchronizationAlgorithm algo, boolean doSync) {
        SynchronizationAlgorithm syncAlgo;
        if (doSync) {
            syncAlgo = SynchronizationManager.synchronize(syncFile, traces, algo);
        } else {
            syncAlgo = SynchronizationManager.openExisting(syncFile);
            if (syncAlgo == null || syncAlgo.getClass() != algo.getClass()) {
                syncAlgo = algo != null ? algo : SynchronizationAlgorithmFactory.getDefaultAlgorithm();
            }
        }
        return syncAlgo;
    }

    private static SynchronizationAlgorithm openExisting(File syncFile) {
        if (syncFile != null && syncFile.exists()) {
            try {
                SynchronizationBackend syncBackend = new SynchronizationBackend(syncFile);
                SynchronizationAlgorithm algo = syncBackend.openExistingSync();
                return algo;
            }
            catch (IOException e) {
                Activator.logInfo("Problem opening existing trace synchronization file", e);
            }
        }
        return null;
    }

    private static SynchronizationAlgorithm synchronize(File syncFile, Collection<ITmfTrace> traces, SynchronizationAlgorithm syncAlgo) {
        TmfEventMatching matching = new TmfEventMatching(traces, syncAlgo);
        matching.matchEvents();
        try {
            SynchronizationBackend syncBackend = new SynchronizationBackend(syncFile, false);
            syncBackend.saveSync(syncAlgo);
        }
        catch (IOException e) {
            Activator.logError("Error while saving trace synchronization file", e);
        }
        return syncAlgo;
    }
}

