/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.Messages;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.TmfMemoryIndex;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceCompleteness;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpointIndex;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;

public class TmfCheckpointIndexer
implements ITmfTraceIndexer {
    protected final ITmfTrace fTrace;
    private final int fCheckpointInterval;
    private boolean fIsIndexing;
    protected final ITmfCheckpointIndex fTraceIndex;
    private ITmfEventRequest fIndexingRequest = null;

    public TmfCheckpointIndexer(ITmfTrace trace) {
        this(trace, 50000);
    }

    public TmfCheckpointIndexer(ITmfTrace trace, int interval) {
        this.fTrace = trace;
        this.fCheckpointInterval = interval;
        this.fTraceIndex = this.createIndex(trace);
        this.fIsIndexing = false;
    }

    protected ITmfCheckpointIndex createIndex(ITmfTrace trace) {
        return new TmfMemoryIndex(trace);
    }

    @Override
    public void dispose() {
        if (this.fIndexingRequest != null && !this.fIndexingRequest.isCompleted()) {
            this.fIndexingRequest.cancel();
        }
        this.fTraceIndex.dispose();
    }

    @Override
    public boolean isIndexing() {
        return this.fIsIndexing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildIndex(long offset, TmfTimeRange range, boolean waitForCompletion) {
        ITmfCheckpointIndex iTmfCheckpointIndex = this.fTraceIndex;
        synchronized (iTmfCheckpointIndex) {
            if (this.fIsIndexing) {
                return;
            }
            this.fIsIndexing = true;
        }
        if (!this.fTraceIndex.isCreatedFromScratch()) {
            TmfTraceUpdatedSignal signal = new TmfTraceUpdatedSignal(this, this.fTrace, new TmfTimeRange(this.fTraceIndex.getTimeRange().getStartTime(), this.fTraceIndex.getTimeRange().getEndTime()), this.fTraceIndex.getNbEvents());
            if (waitForCompletion) {
                this.fTrace.broadcast(signal);
            } else {
                this.fTrace.broadcastAsync(signal);
            }
            this.fIsIndexing = false;
            return;
        }
        final Job job = new Job("Indexing " + this.fTrace.getName() + "..."){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("", -1);
                while (!monitor.isCanceled()) {
                    try {
                        long prevNbEvents = TmfCheckpointIndexer.this.fTrace.getNbEvents();
                        Thread.sleep(250L);
                        long nbEvents = TmfCheckpointIndexer.this.fTrace.getNbEvents();
                        this.setName(String.valueOf(Messages.TmfCheckpointIndexer_Indexing) + ' ' + TmfCheckpointIndexer.this.fTrace.getName() + " (" + nbEvents + ")");
                        long rate = (nbEvents - prevNbEvents) * 4L;
                        monitor.setTaskName(String.valueOf(rate) + " " + Messages.TmfCheckpointIndexer_EventsPerSecond);
                    }
                    catch (InterruptedException e) {
                        return Status.OK_STATUS;
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(!TmfCheckpointIndexer.isCompleteTrace(this.fTrace));
        job.schedule();
        this.fIndexingRequest = new TmfEventRequest(ITmfEvent.class, range, offset, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND){

            @Override
            public void handleData(ITmfEvent event) {
                super.handleData(event);
                if (this.getNbRead() % TmfCheckpointIndexer.this.fCheckpointInterval == 0) {
                    this.updateTraceStatus();
                }
            }

            @Override
            public void handleSuccess() {
                TmfCheckpointIndexer.this.fTraceIndex.setTimeRange(TmfCheckpointIndexer.this.fTrace.getTimeRange());
                TmfCheckpointIndexer.this.fTraceIndex.setNbEvents(TmfCheckpointIndexer.this.fTrace.getNbEvents());
                if (TmfCheckpointIndexer.isCompleteTrace(TmfCheckpointIndexer.this.fTrace)) {
                    TmfCheckpointIndexer.this.fTraceIndex.setIndexComplete();
                }
                this.updateTraceStatus();
            }

            @Override
            public void handleCompleted() {
                job.cancel();
                super.handleCompleted();
                TmfCheckpointIndexer.this.fIsIndexing = false;
            }

            private void updateTraceStatus() {
                if (TmfCheckpointIndexer.this.fTrace.getNbEvents() > 0L) {
                    TmfCheckpointIndexer.this.signalNewTimeRange(TmfCheckpointIndexer.this.fTrace.getStartTime(), TmfCheckpointIndexer.this.fTrace.getEndTime());
                }
            }
        };
        this.fTrace.sendRequest(this.fIndexingRequest);
        if (waitForCompletion) {
            try {
                this.fIndexingRequest.waitForCompletion();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void signalNewTimeRange(@NonNull ITmfTimestamp startTime, @NonNull ITmfTimestamp endTime) {
        this.fTrace.broadcast(new TmfTraceUpdatedSignal(this.fTrace, this.fTrace, new TmfTimeRange(startTime, endTime), this.fTrace.getNbEvents()));
    }

    @Override
    public synchronized void updateIndex(ITmfContext context, ITmfTimestamp timestamp) {
        if (context.getRank() % (long)this.fCheckpointInterval == 0L) {
            long position = context.getRank() / (long)this.fCheckpointInterval;
            if ((long)this.fTraceIndex.size() == position) {
                this.fTraceIndex.insert(new TmfCheckpoint(timestamp, context.getLocation(), position));
            }
        }
    }

    @Override
    public synchronized ITmfContext seekIndex(ITmfTimestamp timestamp) {
        if (timestamp == null) {
            return this.fTrace.seekEvent(0L);
        }
        long index = this.fTraceIndex.binarySearch(new TmfCheckpoint(timestamp, null, 0L));
        index = index < 0L ? Math.max(0L, -(index + 2L)) : Math.max(0L, index - 1L);
        return this.restoreCheckpoint(index);
    }

    @Override
    public ITmfContext seekIndex(long rank) {
        if (rank < 0L) {
            return this.fTrace.seekEvent(0L);
        }
        int index = (int)rank / this.fCheckpointInterval;
        return this.restoreCheckpoint(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITmfContext restoreCheckpoint(long checkpoint) {
        ITmfLocation location = null;
        long index = 0L;
        ITmfCheckpointIndex iTmfCheckpointIndex = this.fTraceIndex;
        synchronized (iTmfCheckpointIndex) {
            if (!this.fTraceIndex.isEmpty()) {
                index = checkpoint;
                if (index >= (long)this.fTraceIndex.size()) {
                    index = this.fTraceIndex.size() - 1;
                }
                location = this.fTraceIndex.get(index).getLocation();
            }
        }
        ITmfContext context = this.fTrace.seekEvent(location);
        context.setRank(index * (long)this.fCheckpointInterval);
        return context;
    }

    protected ITmfCheckpointIndex getTraceIndex() {
        return this.fTraceIndex;
    }

    private static boolean isCompleteTrace(ITmfTrace trace) {
        return !(trace instanceof ITmfTraceCompleteness) || ((ITmfTraceCompleteness)((Object)trace)).isComplete();
    }
}

