/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.context;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfTmfContext;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class CtfTmfContextTest {
    private static final CtfTmfTestTrace testTrace = CtfTmfTestTrace.KERNEL;
    private static final long begin = 1332170682440133097L;
    private static final long end = 1332170692664579801L;
    private CtfTmfTrace trace;

    @Before
    public void setUp() throws TmfTraceException {
        Assume.assumeTrue((boolean)testTrace.exists());
        this.trace = new CtfTmfTrace();
        String path = testTrace.getPath();
        this.trace.initTrace(null, path, CtfTmfEvent.class);
    }

    @Test
    public void testIndexing() {
        CtfTmfContext context = new CtfTmfContext(this.trace);
        context.seek(0L);
        int count = 0;
        while (this.trace.getNext((ITmfContext)context) != null) {
            ++count;
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTooManyContexts() throws InterruptedException {
        int lwcCount = 101;
        double increment = 1.01232145E8;
        final ArrayList vals = new ArrayList();
        ArrayList<1> threads = new ArrayList<1>();
        final ArrayList tooManyContexts = new ArrayList();
        double d = 1.332170682440133E18;
        while (d < 1.3321706926645798E18) {
            SeekerThread thread = new SeekerThread(this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    CtfTmfContext lwc = new CtfTmfContext(trace);
                    lwc.seek(this.val);
                    trace.getNext((ITmfContext)lwc);
                    CtfTmfTrace ctfTmfTrace = trace;
                    synchronized (ctfTmfTrace) {
                        if (lwc.getCurrentEvent() != null) {
                            vals.add(lwc.getCurrentEvent().getTimestamp().getValue());
                        }
                        tooManyContexts.add(lwc);
                    }
                }
            };
            thread.setVal((long)d);
            threads.add(thread);
            thread.start();
            d += increment;
        }
        for (Thread thread : threads) {
            thread.join();
        }
        Assert.assertEquals((String)"seeks done ", (long)102L, (long)vals.size());
        Iterator iterator = vals.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            Assert.assertTrue((String)("val >= begin, " + l + " " + 1332170682440133097L), (l >= 1332170682440133097L ? 1 : 0) != 0);
            Assert.assertTrue((String)("val >= end, " + l + " " + 1332170692664579801L), (l <= 1332170692664579801L ? 1 : 0) != 0);
        }
    }

    private class SeekerThread
    extends Thread {
        long val;

        private SeekerThread() {
        }

        public void setVal(long val) {
            this.val = val;
        }
    }
}

