/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.event;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ArrayDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.types.SequenceDeclaration;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventField;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CtfTmfEventFieldTest {
    @NonNull
    private static final String ROOT = "root";
    private static final String SEQ = "seq";
    @NonNull
    private static final String ARRAY_STR = "array_str";
    @NonNull
    private static final String ARRAY_FLOAT = "array_float";
    @NonNull
    private static final String ARRAY_INT = "array_int";
    @NonNull
    private static final String ARRAY_STRUCT = "array_struct";
    @NonNull
    private static final String ARRAY_VARIANT = "array_variant";
    @NonNull
    private static final String ARRAY_ENUM = "array_enum";
    private static final String STR = "str";
    private static final String FLOAT = "float";
    private static final String LEN = "len";
    private static final String INT = "int";
    private static final String NAME = "test";
    private static final String STRUCT = "struct";
    private static final String VARIANT = "variant";
    private static final String ENUM = "enum";
    private static final byte TEST_NUMBER = 2;
    private static final String TEST_STRING = "two";
    private static final int ARRAY_SIZE = 2;
    private StructDefinition fixture;

    @Before
    public void setUp() throws UnsupportedEncodingException, CTFException {
        byte[] testStringBytes = TEST_STRING.getBytes("UTF-8");
        int capacity = 2048;
        ByteBuffer bb = ByteBuffer.allocateDirect(capacity);
        StructDeclaration sDec = new StructDeclaration(1L);
        StringDeclaration strDec = StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8);
        IntegerDeclaration intDec = IntegerDeclaration.UINT_8_DECL;
        FloatDeclaration flDec = new FloatDeclaration(8, 24, ByteOrder.BIG_ENDIAN, 8L);
        SequenceDeclaration seqDec = new SequenceDeclaration(LEN, (IDeclaration)intDec);
        StructDeclaration structDec = new StructDeclaration(8L);
        EnumDeclaration enumDec = new EnumDeclaration(intDec);
        VariantDeclaration varDec = new VariantDeclaration();
        ArrayDeclaration arrStrDec = new ArrayDeclaration(2, (IDeclaration)strDec);
        ArrayDeclaration arrFloatDec = new ArrayDeclaration(2, (IDeclaration)flDec);
        ArrayDeclaration arrIntDec = new ArrayDeclaration(2, (IDeclaration)intDec);
        ArrayDeclaration arrStructDec = new ArrayDeclaration(2, (IDeclaration)structDec);
        ArrayDeclaration arrVariantDec = new ArrayDeclaration(2, (IDeclaration)varDec);
        ArrayDeclaration arrEnumDec = new ArrayDeclaration(2, (IDeclaration)enumDec);
        sDec.addField(INT, (IDeclaration)intDec);
        bb.put((byte)2);
        sDec.addField(ARRAY_INT, (IDeclaration)arrIntDec);
        int i = 0;
        while (i < 2) {
            bb.put((byte)2);
            ++i;
        }
        sDec.addField(LEN, (IDeclaration)intDec);
        bb.put((byte)2);
        sDec.addField(FLOAT, (IDeclaration)flDec);
        bb.putFloat(2.0f);
        sDec.addField(ARRAY_FLOAT, (IDeclaration)arrFloatDec);
        i = 0;
        while (i < 2) {
            bb.putFloat(2.0f);
            ++i;
        }
        sDec.addField(STR, (IDeclaration)strDec);
        bb.put(testStringBytes);
        bb.put((byte)0);
        sDec.addField(ARRAY_STR, (IDeclaration)arrStrDec);
        i = 0;
        while (i < 2) {
            bb.put(testStringBytes);
            bb.put((byte)0);
            ++i;
        }
        sDec.addField(SEQ, (IDeclaration)seqDec);
        bb.put((byte)2);
        bb.put((byte)2);
        structDec.addField(STR, (IDeclaration)strDec);
        structDec.addField(INT, (IDeclaration)intDec);
        sDec.addField(STRUCT, (IDeclaration)structDec);
        bb.put(testStringBytes);
        bb.put((byte)0);
        bb.put((byte)2);
        sDec.addField(ARRAY_STRUCT, (IDeclaration)arrStructDec);
        i = 0;
        while (i < 2) {
            bb.put(testStringBytes);
            bb.put((byte)0);
            bb.put((byte)2);
            ++i;
        }
        enumDec.add(0L, 1L, LEN);
        enumDec.add(2L, 3L, FLOAT);
        sDec.addField(ENUM, (IDeclaration)enumDec);
        bb.put((byte)2);
        sDec.addField(ARRAY_ENUM, (IDeclaration)arrEnumDec);
        i = 0;
        while (i < 2) {
            bb.put((byte)2);
            ++i;
        }
        varDec.addField(LEN, (IDeclaration)intDec);
        varDec.addField(FLOAT, (IDeclaration)flDec);
        varDec.setTag(ENUM);
        sDec.addField(VARIANT, (IDeclaration)varDec);
        bb.putFloat(2.0f);
        sDec.addField(ARRAY_VARIANT, (IDeclaration)arrVariantDec);
        i = 0;
        while (i < 2) {
            bb.putFloat(2.0f);
            ++i;
        }
        this.fixture = sDec.createDefinition((IDefinitionScope)this.fixture, ROOT, new BitBuffer(bb));
    }

    @Test
    public void testParseField_float() {
        FloatDefinition fieldDef = (FloatDefinition)this.fixture.lookupDefinition(FLOAT);
        CtfTmfEventField result = CtfTmfEventField.parseField((IDefinition)fieldDef, (String)"_test");
        Assert.assertEquals((Object)"test=2.0", (Object)result.toString());
    }

    @Test
    public void testParseField_array_float() {
        AbstractArrayDefinition fieldDef = this.fixture.lookupArrayDefinition(ARRAY_FLOAT);
        CtfTmfEventField result = CtfTmfEventField.parseField((IDefinition)fieldDef, (String)NAME);
        Assert.assertEquals((Object)"test=[2.0, 2.0]", (Object)result.toString());
    }

    @Test
    public void testParseField_int() {
        Definition fieldDef = this.fixture.lookupDefinition(INT);
        CtfTmfEventField result = CtfTmfEventField.parseField((IDefinition)fieldDef, (String)NAME);
        Assert.assertEquals((Object)"test=2", (Object)result.toString());
    }

    @Test
    public void testParseField_array_int() {
        AbstractArrayDefinition fieldDef = this.fixture.lookupArrayDefinition(ARRAY_INT);
        CtfTmfEventField result = CtfTmfEventField.parseField((IDefinition)fieldDef, (String)NAME);
        Assert.assertEquals((Object)"test=[2, 2]", (Object)result.toString());
    }

    @Test
    public void testParseField_sequence() {
        Definition fieldDef = this.fixture.lookupDefinition(SEQ);
        CtfTmfEventField result = CtfTmfEventField.parseField((IDefinition)fieldDef, (String)NAME);
        Assert.assertEquals((Object)"test=[2, 2]", (Object)result.toString());
    }

    @Test
    public void testParseField_sequence_value() {
        Definition fieldDef = this.fixture.lookupDefinition(SEQ);
        CtfTmfEventField result = CtfTmfEventField.parseField((IDefinition)fieldDef, (String)NAME);
        long[] values = (long[])result.getValue();
        long[] expected = new long[]{2L, 2L};
        Assert.assertArrayEquals((long[])expected, (long[])values);
    }

    @Test
    public void testParseField_string() {
        Definition fieldDef = this.fixture.lookupDefinition(STR);
        CtfTmfEventField result = CtfTmfEventField.parseField((IDefinition)fieldDef, (String)NAME);
        Assert.assertEquals((Object)"test=two", (Object)result.toString());
    }

    @Test
    public void testParseField_array_string() {
        AbstractArrayDefinition fieldDef = this.fixture.lookupArrayDefinition(ARRAY_STR);
        CtfTmfEventField result = CtfTmfEventField.parseField((IDefinition)fieldDef, (String)NAME);
        Assert.assertEquals((Object)"test=[two, two]", (Object)result.toString());
    }

    @Test
    public void testParseField_struct() {
        Definition fieldDef = this.fixture.lookupDefinition(STRUCT);
        CtfTmfEventField result = CtfTmfEventField.parseField((IDefinition)fieldDef, (String)NAME);
        Assert.assertEquals((Object)"test=[str=two, int=2]", (Object)result.toString());
    }

    @Test
    public void testParseField_array_struct() {
        AbstractArrayDefinition fieldDef = this.fixture.lookupArrayDefinition(ARRAY_STRUCT);
        CtfTmfEventField result = CtfTmfEventField.parseField((IDefinition)fieldDef, (String)NAME);
        Assert.assertEquals((Object)"test=[[str=two, int=2], [str=two, int=2]]", (Object)result.toString());
    }

    @Test
    public void testParseField_enum() {
        Definition fieldDef = this.fixture.lookupDefinition(ENUM);
        CtfTmfEventField result = CtfTmfEventField.parseField((IDefinition)fieldDef, (String)NAME);
        Assert.assertEquals((Object)"test=float", (Object)result.toString());
    }

    @Test
    public void testParseField_array_enum() {
        AbstractArrayDefinition fieldDef = this.fixture.lookupArrayDefinition(ARRAY_ENUM);
        CtfTmfEventField result = CtfTmfEventField.parseField((IDefinition)fieldDef, (String)NAME);
        Assert.assertEquals((Object)"test=[float, float]", (Object)result.toString());
    }

    @Test
    public void testParseField_variant() {
        Definition fieldDef = this.fixture.lookupDefinition(VARIANT);
        CtfTmfEventField result = CtfTmfEventField.parseField((IDefinition)fieldDef, (String)NAME);
        Assert.assertEquals((Object)"test=float=2.0", (Object)result.toString());
    }

    @Test
    public void testParseField_array_variant() {
        AbstractArrayDefinition fieldDef = this.fixture.lookupArrayDefinition(ARRAY_VARIANT);
        CtfTmfEventField result = CtfTmfEventField.parseField((IDefinition)fieldDef, (String)NAME);
        Assert.assertEquals((Object)"test=[float=2.0, float=2.0]", (Object)result.toString());
    }
}

