/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.iterator;

import org.eclipse.tracecompass.internal.tmf.ctf.core.trace.iterator.CtfIterator;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocationInfo;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class CtfIteratorTest {
    private static final CtfTmfTestTrace testTrace = CtfTmfTestTrace.KERNEL;
    private CtfTmfTrace trace;
    private CtfIterator iterator;

    @Before
    public void setUp() {
        Assume.assumeTrue((boolean)testTrace.exists());
        this.trace = testTrace.getTrace();
        this.iterator = (CtfIterator)this.trace.createIterator();
        CtfLocation ctfLocation = new CtfLocation(new CtfLocationInfo(1L, 0L));
        this.iterator.setLocation((ITmfLocation)ctfLocation);
        this.iterator.increaseRank();
    }

    @After
    public void tearDown() {
        if (this.trace != null) {
            this.trace.dispose();
        }
        if (this.iterator != null) {
            this.iterator.dispose();
        }
    }

    @Test
    public void testCtfIterator_noinit() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CtfIterator result = (CtfIterator)this.trace.createIterator();){
            Assert.assertNotNull((Object)result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testCtfIterator_init() {
        this.trace.init("test");
        Throwable throwable = null;
        Object var2_3 = null;
        try (CtfIterator result = (CtfIterator)this.trace.createIterator();){
            Assert.assertNotNull((Object)result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testCtfIterator_position() {
        long timestampValue = 1L;
        long rank = 1L;
        Throwable throwable = null;
        Object var6_5 = null;
        try (CtfIterator result = (CtfIterator)this.trace.createIterator(new CtfLocationInfo(timestampValue, 0L), rank);){
            Assert.assertNotNull((Object)result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testAdvance() {
        boolean result = this.iterator.advance();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testCompareTo() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CtfIterator o = (CtfIterator)this.trace.createIterator();){
            int result = this.iterator.compareTo(o);
            Assert.assertEquals((long)1L, (long)result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testEquals_other() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CtfIterator obj = (CtfIterator)this.trace.createIterator();){
            Assert.assertNotNull((Object)obj);
            CtfLocation ctfLocation1 = new CtfLocation(new CtfLocationInfo(1L, 0L));
            obj.setLocation((ITmfLocation)ctfLocation1);
            obj.increaseRank();
            boolean result = this.iterator.equals((Object)obj);
            Assert.assertTrue((boolean)result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testEquals_empty() {
        Object obj = new Object();
        boolean result = this.iterator.equals(obj);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testGetCtfTmfTrace() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CtfTmfTrace result = this.iterator.getCtfTmfTrace();){
            Assert.assertNotNull((Object)result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testGetCurrentEvent() {
        CtfTmfEvent result = this.iterator.getCurrentEvent();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetLocation() {
        CtfLocation result = this.iterator.getLocation();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetRank() {
        long result = this.iterator.getRank();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testHasValidRank() {
        boolean result = this.iterator.hasValidRank();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testHashCode() {
        int result = this.iterator.hashCode();
        int result2 = this.iterator.hashCode();
        Assert.assertEquals((long)result, (long)result2);
    }

    @Test
    public void testIncreaseRank() {
        this.iterator.increaseRank();
    }

    @Test
    public void testSeek() {
        long timestamp = 1L;
        boolean result = this.iterator.seek(timestamp);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testSetLocation() {
        CtfLocation location = new CtfLocation(new CtfLocationInfo(1L, 0L));
        this.iterator.setLocation((ITmfLocation)location);
    }
}

