/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.temp.tracemanager;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TmfTraceManagerTest {
    private static final int SCALE = -9;
    private static ITmfTrace trace1;
    private static final long t1start = 1331668247314038062L;
    private static final long t1end = 1331668259054285979L;
    private static ITmfTrace trace2;
    private static final long t2start = 1332170682440133097L;
    private static final long t2end = 1332170692664579801L;
    private static final long ONE_SECOND = 1000000000L;
    private TmfTraceManager tm;

    @BeforeClass
    public static void setUpClass() {
        Assume.assumeTrue((boolean)CtfTmfTestTrace.TRACE2.exists());
        Assume.assumeTrue((boolean)CtfTmfTestTrace.KERNEL.exists());
        trace1 = CtfTmfTestTrace.TRACE2.getTrace();
        trace2 = CtfTmfTestTrace.KERNEL.getTrace();
        trace1.indexTrace(true);
        trace2.indexTrace(true);
        TmfSignalManager.deregister((Object)trace1);
        TmfSignalManager.deregister((Object)trace2);
    }

    @Before
    public void setUp() {
        this.tm = TmfTraceManager.getInstance();
    }

    @After
    public void tearDown() {
        while (this.tm.getActiveTrace() != null) {
            this.closeTrace(this.tm.getActiveTrace());
        }
    }

    @AfterClass
    public static void tearDownClass() {
        CtfTmfTestTrace.TRACE2.dispose();
        CtfTmfTestTrace.KERNEL.dispose();
    }

    private void openTrace(ITmfTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException();
        }
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceOpenedSignal((Object)this, trace, null));
        this.selectTrace(trace);
    }

    private void closeTrace(ITmfTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException();
        }
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceClosedSignal((Object)this, trace));
        if (this.tm.getOpenedTraces().size() > 0) {
            this.selectTrace(this.tm.getOpenedTraces().toArray(new ITmfTrace[0])[0]);
        }
    }

    private void selectTrace(ITmfTrace trace) {
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceSelectedSignal((Object)this, trace));
    }

    private void selectTimestamp(@NonNull ITmfTimestamp ts) {
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, ts));
    }

    private void selectWindowRange(TmfTimeRange tr) {
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, tr));
    }

    @Test
    public void testInitialize() {
        TmfTraceManager mgr = TmfTraceManager.getInstance();
        Assert.assertNotNull((Object)mgr);
        Assert.assertSame((Object)this.tm, (Object)mgr);
    }

    @Test
    public void testTraceSet() {
        this.openTrace(trace1);
        this.openTrace(trace2);
        this.selectTrace(trace2);
        Set<ITmfTrace> expected = Collections.singleton(trace2);
        Collection actual = this.tm.getActiveTraceSet();
        Assert.assertEquals((long)1L, (long)actual.size());
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testTraceSetExperiment() {
        TmfExperiment exp = TmfTraceManagerTest.createExperiment(trace1, trace2);
        this.openTrace(trace1);
        this.openTrace((ITmfTrace)exp);
        ImmutableSet expected = ImmutableSet.of((Object)trace1, (Object)trace2);
        Collection actual = this.tm.getActiveTraceSet();
        Assert.assertEquals((long)2L, (long)actual.size());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testTraceSetWithExperiment() {
        ImmutableSet expected = Collections.singleton(trace1);
        Collection actual = TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)trace1);
        Assert.assertEquals((long)1L, (long)actual.size());
        Assert.assertEquals(expected, (Object)actual);
        TmfExperiment exp = TmfTraceManagerTest.createExperiment(trace1, trace2);
        expected = ImmutableSet.of((Object)trace1, (Object)trace2, (Object)exp);
        actual = TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)exp);
        Assert.assertEquals((long)3L, (long)actual.size());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSupplementaryFileDir() {
        String name1 = trace1.getName();
        String name2 = trace2.getName();
        String basePath = String.valueOf(TmfTraceManager.getTemporaryDirPath()) + File.separator;
        String expected1 = String.valueOf(basePath) + name1 + File.separator;
        String expected2 = String.valueOf(basePath) + name2 + File.separator;
        Assert.assertEquals((Object)expected1, (Object)TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace1));
        Assert.assertEquals((Object)expected2, (Object)TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace2));
    }

    @Test
    public void testTraceInitialRange() {
        this.openTrace(trace2);
        TmfTimeRange expectedRange = new TmfTimeRange(trace2.getStartTime(), TmfTraceManagerTest.calculateOffset(trace2.getStartTime(), trace2.getInitialRangeOffset()));
        TmfTimeRange actualRange = this.tm.getCurrentTraceContext().getWindowRange();
        Assert.assertEquals((Object)expectedRange, (Object)actualRange);
    }

    @Test
    public void testNewTimestamp() {
        this.openTrace(trace2);
        TmfTimestamp ts = new TmfTimestamp(1332170683440133097L, -9);
        this.selectTimestamp((ITmfTimestamp)ts);
        TmfTimeRange selection = this.tm.getCurrentTraceContext().getSelectionRange();
        Assert.assertEquals((Object)ts, (Object)selection.getStartTime());
        Assert.assertEquals((Object)ts, (Object)selection.getEndTime());
    }

    @Test
    public void testTimestampBefore() {
        this.openTrace(trace2);
        TmfTimeRange beforeTr = this.tm.getCurrentTraceContext().getSelectionRange();
        TmfTimestamp ts = new TmfTimestamp(1332170681440133097L, -9);
        this.selectTimestamp((ITmfTimestamp)ts);
        TmfTimeRange selection = this.tm.getCurrentTraceContext().getSelectionRange();
        Assert.assertEquals((Object)beforeTr, (Object)selection);
    }

    @Test
    public void testTimestampAfter() {
        this.openTrace(trace2);
        TmfTimeRange beforeTr = this.tm.getCurrentTraceContext().getSelectionRange();
        TmfTimestamp ts = new TmfTimestamp(1332170693664579801L, -9);
        this.selectTimestamp((ITmfTimestamp)ts);
        TmfTimeRange selection = this.tm.getCurrentTraceContext().getSelectionRange();
        Assert.assertEquals((Object)beforeTr, (Object)selection);
    }

    @Test
    public void testTraceNewTimeRange() {
        this.openTrace(trace2);
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(1332170683440133097L, -9), (ITmfTimestamp)new TmfTimestamp(1332170691664579801L, -9));
        this.selectWindowRange(range);
        TmfTimeRange curRange = this.tm.getCurrentTraceContext().getWindowRange();
        Assert.assertEquals((Object)range, (Object)curRange);
    }

    @Test
    public void testTraceTimeRangeClampingStart() {
        this.openTrace(trace2);
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(1332170681440133097L, -9), (ITmfTimestamp)new TmfTimestamp(1332170691664579801L, -9));
        this.selectWindowRange(range);
        TmfTimeRange curRange = this.tm.getCurrentTraceContext().getWindowRange();
        Assert.assertEquals((long)1332170682440133097L, (long)curRange.getStartTime().getValue());
        Assert.assertEquals((Object)range.getEndTime(), (Object)curRange.getEndTime());
    }

    @Test
    public void testTraceTimeRangeClampingEnd() {
        this.openTrace(trace2);
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(1332170683440133097L, -9), (ITmfTimestamp)new TmfTimestamp(1332170693664579801L, -9));
        this.selectWindowRange(range);
        TmfTimeRange curRange = this.tm.getCurrentTraceContext().getWindowRange();
        Assert.assertEquals((Object)range.getStartTime(), (Object)curRange.getStartTime());
        Assert.assertEquals((long)1332170692664579801L, (long)curRange.getEndTime().getValue());
    }

    @Test
    public void testTraceTimeRangeClampingBoth() {
        this.openTrace(trace2);
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(1332170681440133097L, -9), (ITmfTimestamp)new TmfTimestamp(1332170693664579801L, -9));
        this.selectWindowRange(range);
        TmfTimeRange curRange = this.tm.getCurrentTraceContext().getWindowRange();
        Assert.assertEquals((long)1332170682440133097L, (long)curRange.getStartTime().getValue());
        Assert.assertEquals((long)1332170692664579801L, (long)curRange.getEndTime().getValue());
    }

    @Test
    public void testTwoTracesTimestampValid() {
        this.openTrace(trace1);
        this.openTrace(trace2);
        this.selectTrace(trace1);
        TmfTimestamp ts = new TmfTimestamp(1331668248314038062L, -9);
        this.selectTimestamp((ITmfTimestamp)ts);
        TmfTraceContext ctx = this.tm.getCurrentTraceContext();
        Assert.assertEquals((Object)ts, (Object)ctx.getSelectionRange().getStartTime());
        Assert.assertEquals((Object)ts, (Object)ctx.getSelectionRange().getEndTime());
        this.selectTrace(trace2);
        ctx = this.tm.getCurrentTraceContext();
        Assert.assertEquals((Object)trace2.getStartTime(), (Object)ctx.getSelectionRange().getStartTime());
        Assert.assertEquals((Object)trace2.getStartTime(), (Object)ctx.getSelectionRange().getEndTime());
    }

    @Test
    public void testTwoTracesTimestampInBetween() {
        this.openTrace(trace1);
        this.openTrace(trace2);
        this.selectTrace(trace1);
        TmfTimestamp ts = new TmfTimestamp(1331668260054285979L, -9);
        this.selectTimestamp((ITmfTimestamp)ts);
        TmfTimeRange selection = this.tm.getCurrentTraceContext().getSelectionRange();
        Assert.assertEquals((Object)trace1.getStartTime(), (Object)selection.getStartTime());
        Assert.assertEquals((Object)trace1.getStartTime(), (Object)selection.getEndTime());
        this.selectTrace(trace2);
        selection = this.tm.getCurrentTraceContext().getSelectionRange();
        Assert.assertEquals((Object)trace2.getStartTime(), (Object)selection.getStartTime());
        Assert.assertEquals((Object)trace2.getStartTime(), (Object)selection.getEndTime());
    }

    @Test
    public void testTwoTracesTimestampInvalid() {
        this.openTrace(trace1);
        this.openTrace(trace2);
        this.selectTrace(trace1);
        TmfTimestamp ts = new TmfTimestamp(1332170693664579801L, -9);
        this.selectTimestamp((ITmfTimestamp)ts);
        TmfTimeRange selection = this.tm.getCurrentTraceContext().getSelectionRange();
        Assert.assertEquals((Object)trace1.getStartTime(), (Object)selection.getStartTime());
        Assert.assertEquals((Object)trace1.getStartTime(), (Object)selection.getEndTime());
        this.selectTrace(trace2);
        selection = this.tm.getCurrentTraceContext().getSelectionRange();
        Assert.assertEquals((Object)trace2.getStartTime(), (Object)selection.getStartTime());
        Assert.assertEquals((Object)trace2.getStartTime(), (Object)selection.getEndTime());
    }

    @Test
    public void testTwoTracesTimeRangeAllInOne() {
        this.openTrace(trace1);
        this.openTrace(trace2);
        this.selectTrace(trace1);
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(1331668248314038062L, -9), (ITmfTimestamp)new TmfTimestamp(1331668258054285979L, -9));
        this.selectWindowRange(range);
        Assert.assertEquals((Object)range, (Object)this.tm.getCurrentTraceContext().getWindowRange());
        this.selectTrace(trace2);
        Assert.assertEquals((Object)TmfTraceManagerTest.getInitialRange(trace2), (Object)this.tm.getCurrentTraceContext().getWindowRange());
    }

    @Test
    public void testTwoTracesTimeRangePartiallyInOne() {
        this.openTrace(trace1);
        this.openTrace(trace2);
        this.selectTrace(trace1);
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(1331668248314038062L, -9), (ITmfTimestamp)new TmfTimestamp(1331668260054285979L, -9));
        this.selectWindowRange(range);
        TmfTimeRange expectedRange = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(1331668248314038062L, -9), (ITmfTimestamp)new TmfTimestamp(1331668259054285979L, -9));
        Assert.assertEquals((Object)expectedRange, (Object)this.tm.getCurrentTraceContext().getWindowRange());
        this.selectTrace(trace2);
        Assert.assertEquals((Object)TmfTraceManagerTest.getInitialRange(trace2), (Object)this.tm.getCurrentTraceContext().getWindowRange());
    }

    @Test
    public void testTwoTracesTimeRangeInBoth() {
        this.openTrace(trace1);
        this.openTrace(trace2);
        this.selectTrace(trace1);
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(1331668258054285979L, -9), (ITmfTimestamp)new TmfTimestamp(1332170683440133097L, -9));
        this.selectWindowRange(range);
        TmfTimeRange expectedRange = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(1331668258054285979L, -9), (ITmfTimestamp)new TmfTimestamp(1331668259054285979L, -9));
        Assert.assertEquals((Object)expectedRange, (Object)this.tm.getCurrentTraceContext().getWindowRange());
        this.selectTrace(trace2);
        expectedRange = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(1332170682440133097L, -9), (ITmfTimestamp)new TmfTimestamp(1332170683440133097L, -9));
        Assert.assertEquals((Object)expectedRange, (Object)this.tm.getCurrentTraceContext().getWindowRange());
    }

    @Test
    public void testTwoTracesTimeRangeInBetween() {
        this.openTrace(trace1);
        this.openTrace(trace2);
        this.selectTrace(trace1);
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(1331668260054285979L, -9), (ITmfTimestamp)new TmfTimestamp(1331668258054285979L, -9));
        this.selectWindowRange(range);
        TmfTimeRange expectedRange = TmfTraceManagerTest.getInitialRange(trace1);
        TmfTimeRange curRange = this.tm.getCurrentTraceContext().getWindowRange();
        Assert.assertEquals((Object)expectedRange.getStartTime(), (Object)curRange.getStartTime());
        Assert.assertEquals((Object)expectedRange.getEndTime(), (Object)curRange.getEndTime());
        this.selectTrace(trace2);
        expectedRange = TmfTraceManagerTest.getInitialRange(trace2);
        curRange = this.tm.getCurrentTraceContext().getWindowRange();
        Assert.assertEquals((Object)expectedRange.getStartTime(), (Object)curRange.getStartTime());
        Assert.assertEquals((Object)expectedRange.getEndTime(), (Object)curRange.getEndTime());
    }

    @Test
    public void testExperimentTimestampInTrace() {
        TmfExperiment exp = TmfTraceManagerTest.createExperiment(trace1, trace2);
        this.openTrace((ITmfTrace)exp);
        TmfTimestamp ts = new TmfTimestamp(1331668248314038062L, -9);
        this.selectTimestamp((ITmfTimestamp)ts);
        TmfTimeRange selection = this.tm.getCurrentTraceContext().getSelectionRange();
        Assert.assertEquals((Object)ts, (Object)selection.getStartTime());
        Assert.assertEquals((Object)ts, (Object)selection.getEndTime());
    }

    @Test
    public void testExperimentTimestampInBetween() {
        TmfExperiment exp = TmfTraceManagerTest.createExperiment(trace1, trace2);
        this.openTrace((ITmfTrace)exp);
        TmfTimestamp ts = new TmfTimestamp(1331668260054285979L, -9);
        this.selectTimestamp((ITmfTimestamp)ts);
        TmfTimeRange selection = this.tm.getCurrentTraceContext().getSelectionRange();
        Assert.assertEquals((Object)ts, (Object)selection.getStartTime());
        Assert.assertEquals((Object)ts, (Object)selection.getEndTime());
    }

    @Test
    public void testExperimentTimestampInvalid() {
        TmfExperiment exp = TmfTraceManagerTest.createExperiment(trace1, trace2);
        this.openTrace((ITmfTrace)exp);
        TmfTimestamp ts = new TmfTimestamp(1332170693664579801L, -9);
        this.selectTimestamp((ITmfTimestamp)ts);
        TmfTimeRange selection = this.tm.getCurrentTraceContext().getSelectionRange();
        Assert.assertEquals((Object)trace1.getStartTime(), (Object)selection.getStartTime());
        Assert.assertEquals((Object)trace1.getStartTime(), (Object)selection.getEndTime());
    }

    @Test
    public void testExperimentInitialRange() {
        TmfExperiment exp = TmfTraceManagerTest.createExperiment(trace1, trace2);
        this.openTrace((ITmfTrace)exp);
        TmfTimeRange actualRange = this.tm.getCurrentTraceContext().getWindowRange();
        Assert.assertEquals((Object)TmfTraceManagerTest.getInitialRange(trace1), (Object)actualRange);
        Assert.assertEquals((Object)TmfTraceManagerTest.getInitialRange((ITmfTrace)exp), (Object)actualRange);
    }

    @Test
    public void testExperimentRangeClampingOne() {
        TmfExperiment exp = TmfTraceManagerTest.createExperiment(trace1, trace2);
        this.openTrace((ITmfTrace)exp);
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(1331668246314038062L, -9), (ITmfTimestamp)new TmfTimestamp(1331668258054285979L, -9));
        this.selectWindowRange(range);
        TmfTimeRange actualRange = this.tm.getCurrentTraceContext().getWindowRange();
        Assert.assertEquals((long)1331668247314038062L, (long)actualRange.getStartTime().getValue());
        Assert.assertEquals((long)1331668258054285979L, (long)actualRange.getEndTime().getValue());
    }

    @Test
    public void testExperimentRangeClampingBoth() {
        TmfExperiment exp = TmfTraceManagerTest.createExperiment(trace1, trace2);
        this.openTrace((ITmfTrace)exp);
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(1331668246314038062L, -9), (ITmfTimestamp)new TmfTimestamp(1332170693664579801L, -9));
        this.selectWindowRange(range);
        TmfTimeRange actualRange = this.tm.getCurrentTraceContext().getWindowRange();
        Assert.assertEquals((long)1331668247314038062L, (long)actualRange.getStartTime().getValue());
        Assert.assertEquals((long)1332170692664579801L, (long)actualRange.getEndTime().getValue());
    }

    @Test
    public void testExperimentRangeInBetween() {
        TmfExperiment exp = TmfTraceManagerTest.createExperiment(trace1, trace2);
        this.openTrace((ITmfTrace)exp);
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(1331668260054285979L, -9), (ITmfTimestamp)new TmfTimestamp(1332170681440133097L, -9));
        this.selectWindowRange(range);
        TmfTimeRange actualRange = this.tm.getCurrentTraceContext().getWindowRange();
        Assert.assertEquals((Object)range, (Object)actualRange);
    }

    private static TmfExperiment createExperiment(ITmfTrace t1, ITmfTrace t2) {
        ITmfTrace[] traces = new ITmfTrace[]{t1, t2};
        TmfExperiment exp = new TmfExperiment(ITmfEvent.class, "test-exp", traces, 5000, null);
        exp.indexTrace(true);
        TmfSignalManager.deregister((Object)exp);
        return exp;
    }

    private static TmfTimeRange getInitialRange(ITmfTrace trace) {
        return new TmfTimeRange(trace.getStartTime(), TmfTraceManagerTest.calculateOffset(trace.getStartTime(), trace.getInitialRangeOffset()));
    }

    @NonNull
    private static ITmfTimestamp calculateOffset(ITmfTimestamp initialTs, ITmfTimestamp offsetTs) {
        long start = initialTs.normalize(0L, -9).getValue();
        long offset = offsetTs.normalize(0L, -9).getValue();
        return new TmfTimestamp(start + offset, -9);
    }
}

