/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.pcap.core.tests.event;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.PcapEvent;
import org.eclipse.tracecompass.internal.tmf.pcap.core.protocol.TmfPcapProtocol;
import org.eclipse.tracecompass.internal.tmf.pcap.core.trace.PcapTrace;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class PcapEventTest {
    private static PcapEvent fEvent;
    private static List<TmfPcapProtocol> fProtocolList;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BeforeClass
    public static void setUp() throws IOException, BadPcapFileException, TmfTraceException {
        block13: {
            PcapTestTrace trace = PcapTestTrace.MOSTLY_TCP;
            Assume.assumeTrue((boolean)trace.exists());
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                PcapFile pcap = new PcapFile(trace.getPath());
                try {
                    try (PcapTrace pcapTrace = new PcapTrace();){
                        pcapTrace.initTrace(null, trace.getPath().toString(), PcapEvent.class);
                        fEvent = pcapTrace.parseEvent((ITmfContext)new TmfContext((ITmfLocation)new TmfLongLocation(3L), 3L));
                    }
                    if (pcap == null) break block13;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (pcap == null) throw throwable;
                    pcap.close();
                    throw throwable;
                }
                pcap.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        ArrayList<TmfPcapProtocol> list = new ArrayList<TmfPcapProtocol>();
        list.add(TmfPcapProtocol.PCAP);
        list.add(TmfPcapProtocol.ETHERNET_II);
        list.add(TmfPcapProtocol.IPV4);
        list.add(TmfPcapProtocol.TCP);
        list.add(TmfPcapProtocol.UNKNOWN);
        fProtocolList = ImmutableList.copyOf(list);
    }

    @Test
    public void getProtocolsTest() {
        Assert.assertEquals(fProtocolList, (Object)fEvent.getProtocols());
    }

    @Test
    public void getMostEncapsulatedProtocolTest() {
        Assert.assertEquals((Object)TmfPcapProtocol.TCP, (Object)fEvent.getMostEncapsulatedProtocol());
    }

    @Test
    public void getFieldsTest() {
        Map map = fEvent.getFields(TmfPcapProtocol.IPV4);
        if (map == null) {
            Assert.fail((String)"getFieldsTest() failed because map is null!");
            return;
        }
        Assert.assertEquals((Object)"145.254.160.237", map.get("Source IP Address"));
    }

    @Test
    public void getPayloadTest() {
        ByteBuffer bb = fEvent.getPayload(TmfPcapProtocol.TCP);
        if (bb == null) {
            Assert.fail((String)"getPayloadTest() failed because bb is null!");
            return;
        }
        Assert.assertEquals((long)71L, (long)bb.get());
    }

    @Test
    public void getSourceEndpointTest() {
        Assert.assertEquals((Object)"00:00:01:00:00:00/145.254.160.237/3372", (Object)fEvent.getSourceEndpoint(TmfPcapProtocol.TCP));
    }

    @Test
    public void getDestinationEndpointTest() {
        Assert.assertEquals((Object)"fe:ff:20:00:01:00", (Object)fEvent.getDestinationEndpoint(TmfPcapProtocol.ETHERNET_II));
    }

    @Test
    public void toStringTest() {
        Assert.assertEquals((Object)"3372 > 80 [ACK, PSH] Seq=951057940 Ack=290218380 Len=20", (Object)fEvent.toString());
    }

    @Test
    public void toStringAtSpecificProtocolTest() {
        Assert.assertEquals((Object)"Src: 145.254.160.237 , Dst: 65.208.228.223", (Object)fEvent.toString(TmfPcapProtocol.IPV4));
    }
}

