/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.pcap.core.event;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.pcap.core.packet.Packet;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;

public class PcapRootEventField
extends TmfEventField {
    private final TmfEventField fPacketSourceField;
    private final TmfEventField fPacketDestinationField;
    private final TmfEventField fProtocolField;
    private final String fSummaryString;

    public PcapRootEventField(@Nullable ITmfEventField[] fields, Packet packet) {
        super(":root:", null, fields);
        this.fPacketSourceField = new TmfEventField(":packetsource:", (Object)packet.getMostEcapsulatedPacket().getSourceEndpoint().toString(), null);
        this.fPacketDestinationField = new TmfEventField(":packetdestination:", (Object)packet.getMostEcapsulatedPacket().getDestinationEndpoint().toString(), null);
        this.fProtocolField = new TmfEventField(":protocol:", (Object)packet.getMostEcapsulatedPacket().getProtocol().getShortName().toUpperCase(), null);
        this.fSummaryString = packet.getGlobalSummaryString();
    }

    public PcapRootEventField(PcapRootEventField field) {
        super((TmfEventField)field);
        this.fPacketSourceField = field.fPacketSourceField;
        this.fPacketDestinationField = field.fPacketDestinationField;
        this.fProtocolField = field.fProtocolField;
        this.fSummaryString = field.fSummaryString;
    }

    public String toString() {
        return this.fSummaryString;
    }

    @Nullable
    public ITmfEventField getField(String ... path) {
        if (path.length != 1) {
            return super.getField(path);
        }
        switch (path[0]) {
            case ":packetsource:": {
                return this.fPacketSourceField;
            }
            case ":packetdestination:": {
                return this.fPacketDestinationField;
            }
            case ":protocol:": {
                return this.fProtocolField;
            }
        }
        return super.getField(path);
    }
}

