/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.pcap.core.trace;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.util.LinkTypeHelper;
import org.eclipse.tracecompass.internal.tmf.pcap.core.Activator;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.PcapEvent;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.aspect.PcapDestinationAspect;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.aspect.PcapProtocolAspect;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.aspect.PcapReferenceAspect;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.aspect.PcapSourceAspect;
import org.eclipse.tracecompass.internal.tmf.pcap.core.trace.Messages;
import org.eclipse.tracecompass.internal.tmf.pcap.core.util.PcapEventFactory;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceProperties;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;

public class PcapTrace
extends TmfTrace
implements ITmfTraceProperties,
AutoCloseable {
    public static final String TRACE_TYPE_ID = "org.eclipse.linuxtools.tmf.pcap.core.pcaptrace";
    private static final Collection<ITmfEventAspect> PCAP_ASPECTS = (Collection)NonNullUtils.checkNotNull((Object)ImmutableList.of((Object)ITmfEventAspect.BaseAspects.TIMESTAMP, (Object)PcapSourceAspect.INSTANCE, (Object)PcapDestinationAspect.INSTANCE, (Object)PcapReferenceAspect.INSTANCE, (Object)PcapProtocolAspect.INSTANCE, (Object)ITmfEventAspect.BaseAspects.CONTENTS));
    private static final String EMPTY_STRING = "";
    private static final int CONFIDENCE = 50;
    @Nullable
    private PcapFile fPcapFile;
    @Nullable
    private Map<String, String> fTraceProperties = null;

    public synchronized ITmfLocation getCurrentLocation() {
        PcapFile pcap = this.fPcapFile;
        if (pcap == null) {
            return new TmfLongLocation(0L);
        }
        return new TmfLongLocation(pcap.getCurrentRank());
    }

    public synchronized double getLocationRatio(@Nullable ITmfLocation location) {
        TmfLongLocation loc = (TmfLongLocation)location;
        PcapFile pcap = this.fPcapFile;
        if (loc == null || pcap == null) {
            return 0.0;
        }
        try {
            return pcap.getTotalNbPackets() == 0L ? 0.0 : (double)loc.getLocationInfo().longValue() / (double)pcap.getTotalNbPackets();
        }
        catch (IOException | BadPcapFileException e) {
            String message = e.getMessage();
            if (message == null) {
                message = EMPTY_STRING;
            }
            Activator.logError(message, e);
            return 0.0;
        }
    }

    public synchronized void initTrace(@Nullable IResource resource, @Nullable String path, @Nullable Class<? extends ITmfEvent> type) throws TmfTraceException {
        super.initTrace(resource, path, type);
        if (path == null) {
            throw new TmfTraceException("No path has been specified.");
        }
        Path filePath = (Path)NonNullUtils.checkNotNull((Object)Paths.get(path, new String[0]));
        try {
            this.fPcapFile = new PcapFile(filePath);
        }
        catch (IOException | BadPcapFileException e) {
            throw new TmfTraceException(e.getMessage(), e);
        }
    }

    public Iterable<ITmfEventAspect> getEventAspects() {
        return PCAP_ASPECTS;
    }

    @Nullable
    public synchronized PcapEvent parseEvent(@Nullable ITmfContext context) {
        if (context == null) {
            return null;
        }
        long rank = context.getRank();
        PcapPacket packet = null;
        PcapFile pcap = this.fPcapFile;
        if (pcap == null) {
            return null;
        }
        try {
            pcap.seekPacket(rank);
            packet = pcap.parseNextPacket();
        }
        catch (ClosedChannelException e) {
            return null;
        }
        catch (IOException | BadPacketException | BadPcapFileException e) {
            String message = e.getMessage();
            if (message == null) {
                message = EMPTY_STRING;
            }
            Activator.logError(message, e);
            return null;
        }
        if (packet == null) {
            return null;
        }
        return PcapEventFactory.createEvent(packet, pcap, this);
    }

    public synchronized ITmfContext seekEvent(double ratio) {
        long position;
        PcapFile pcap = this.fPcapFile;
        if (pcap == null) {
            return new TmfContext((ITmfLocation)new TmfLongLocation(0L), 0L);
        }
        try {
            position = (long)(ratio * (double)pcap.getTotalNbPackets());
        }
        catch (IOException | BadPcapFileException e) {
            String message = e.getMessage();
            if (message == null) {
                message = EMPTY_STRING;
            }
            Activator.logError(message, e);
            return new TmfContext((ITmfLocation)new TmfLongLocation(0L), 0L);
        }
        TmfLongLocation loc = new TmfLongLocation(position);
        return new TmfContext((ITmfLocation)loc, loc.getLocationInfo().longValue());
    }

    public synchronized ITmfContext seekEvent(@Nullable ITmfLocation location) {
        TmfLongLocation loc = (TmfLongLocation)location;
        if (loc == null) {
            return new TmfContext((ITmfLocation)new TmfLongLocation(0L));
        }
        return new TmfContext((ITmfLocation)loc, loc.getLocationInfo().longValue());
    }

    public IStatus validate(@Nullable IProject project, @Nullable String path) {
        if (path == null) {
            return new Status(4, "org.eclipse.tracecompass.tmf.pcap.core", EMPTY_STRING);
        }
        Path filePath = (Path)NonNullUtils.checkNotNull((Object)Paths.get(path, new String[0]));
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                PcapFile file = new PcapFile(filePath);
                if (file != null) {
                    file.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | BadPcapFileException e) {
            return new Status(4, "org.eclipse.tracecompass.tmf.pcap.core", e.toString());
        }
        return new TraceValidationStatus(50, "org.eclipse.tracecompass.tmf.pcap.core");
    }

    public synchronized void dispose() {
        super.dispose();
        PcapFile pcap = this.fPcapFile;
        if (pcap == null) {
            return;
        }
        try {
            pcap.close();
            this.fPcapFile = null;
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message == null) {
                message = EMPTY_STRING;
            }
            Activator.logError(message, e);
            return;
        }
    }

    public synchronized Map<String, String> getTraceProperties() {
        PcapFile pcap = this.fPcapFile;
        if (pcap == null) {
            return (Map)NonNullUtils.checkNotNull(Collections.emptyMap());
        }
        Map<String, String> properties = this.fTraceProperties;
        if (properties == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)Messages.PcapTrace_Version, (Object)String.format("%d%c%d", pcap.getMajorVersion(), Character.valueOf('.'), pcap.getMinorVersion()));
            builder.put((Object)Messages.PcapTrace_TimeZoneCorrection, (Object)(String.valueOf(pcap.getTimeZoneCorrection()) + " s"));
            builder.put((Object)Messages.PcapTrace_TimestampAccuracy, (Object)String.valueOf(pcap.getTimeAccuracy()));
            builder.put((Object)Messages.PcapTrace_MaxSnapLength, (Object)(String.valueOf(pcap.getSnapLength()) + " bytes"));
            builder.put((Object)Messages.PcapTrace_LinkLayerHeaderType, (Object)(String.valueOf(LinkTypeHelper.toString((int)((int)pcap.getDataLinkType()))) + " (" + pcap.getDataLinkType() + ")"));
            builder.put((Object)Messages.PcapTrace_FileEndianness, (Object)pcap.getByteOrder().toString());
            return (Map)NonNullUtils.checkNotNull((Object)builder.build());
        }
        return properties;
    }

    @Override
    public void close() {
        this.dispose();
    }
}

