/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.remote.core.tests.shell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.remote.core.shell.CommandInput;
import org.junit.Assert;
import org.junit.Test;

public class CommandInputTest {
    @NonNull
    private static final String COMMAND = "my-command";
    @NonNull
    private static final String[] CMD_INPUT = new String[]{"This", "are", "the", "params"};

    @Test
    public void testConstructorAndAdd() {
        CommandInput iunput = new CommandInput();
        iunput.add(COMMAND);
        List<String> params = Arrays.asList(CMD_INPUT);
        iunput.addAll((List)NonNullUtils.checkNotNull(params));
        ArrayList<String> expectedList = new ArrayList<String>();
        expectedList.add(COMMAND);
        expectedList.addAll(params);
        Assert.assertEquals(expectedList, (Object)iunput.getInput());
        String expected = CommandInputTest.expectedInputString();
        Assert.assertEquals((Object)expected, (Object)iunput.toString());
    }

    @Test
    public void testNullSegment() {
        CommandInput input = new CommandInput();
        input.add(null);
        Assert.assertEquals((long)0L, (long)input.getInput().size());
    }

    private static String expectedInputString() {
        StringBuilder builder = new StringBuilder();
        builder.append(COMMAND).append(' ');
        String[] stringArray = CMD_INPUT;
        int n = CMD_INPUT.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            builder.append(segment).append(' ');
            ++n2;
        }
        return builder.toString().trim();
    }
}

