/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.remote.core.tests.shell;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandInput;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandResult;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandShell;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class CommandShellTest {
    private static final boolean IS_UNIX = !Platform.getOS().equals("win32");
    @NonNull
    private static final String[] CMD_INPUT_UNIX = new String[]{"ls", "-l"};
    @NonNull
    private static final String[] CMD_ERROR_INPUT_UNIX = new String[]{"ls", "blablablabla"};
    @NonNull
    private static final String[] CMD_UNKNOWN_COMMAND_UNIX = new String[]{"blablablabla"};
    private static final IRemoteConnection LOCAL_CONNECTION = TmfRemoteConnectionFactory.getLocalConnection();
    private static final RemoteSystemProxy LOCAL_PROXY = new RemoteSystemProxy((IRemoteConnection)NonNullUtils.checkNotNull((Object)LOCAL_CONNECTION));

    @Test
    public void testExecuteSuccess() throws ExecutionException {
        Assume.assumeTrue((boolean)IS_UNIX);
        LOCAL_PROXY.connect((IProgressMonitor)new NullProgressMonitor());
        ICommandShell shell = LOCAL_PROXY.createCommandShell();
        ICommandInput command = shell.createCommand();
        command.addAll((List)NonNullUtils.checkNotNull(Arrays.asList(CMD_INPUT_UNIX)));
        ICommandResult result = shell.executeCommand(command, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)0L, (long)result.getResult());
    }

    @Test
    public void testExecuteError() throws ExecutionException {
        Assume.assumeTrue((boolean)IS_UNIX);
        LOCAL_PROXY.connect((IProgressMonitor)new NullProgressMonitor());
        ICommandShell shell = LOCAL_PROXY.createCommandShell();
        ICommandInput command = shell.createCommand();
        command.addAll((List)NonNullUtils.checkNotNull(Arrays.asList(CMD_ERROR_INPUT_UNIX)));
        ICommandResult result = shell.executeCommand(command, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((result.getResult() > 0 ? 1 : 0) != 0);
    }

    @Test(expected=ExecutionException.class)
    public void testExecuteException() throws ExecutionException {
        if (!IS_UNIX) {
            throw new ExecutionException("");
        }
        LOCAL_PROXY.connect((IProgressMonitor)new NullProgressMonitor());
        ICommandShell shell = LOCAL_PROXY.createCommandShell();
        ICommandInput command = shell.createCommand();
        command.addAll((List)NonNullUtils.checkNotNull(Arrays.asList(CMD_UNKNOWN_COMMAND_UNIX)));
        ICommandResult result = shell.executeCommand(command, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((result.getResult() > 0 ? 1 : 0) != 0);
    }
}

