/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.statistics;

import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfStatisticsTree;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfStatisticsTreeManager;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfStatisticsTreeNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfStatisticsTreeManagerTest {
    private TmfStatisticsTree fStatisticsData1;
    private TmfStatisticsTree fStatisticsData2;
    private TmfStatisticsTree fStatisticsData3;
    private String fDataKey1 = "key1";
    private String fDataKey2 = "key2";
    private String fDataKey3 = "key3";

    @Before
    public void setUp() {
        this.fStatisticsData1 = new TmfStatisticsTree();
        this.fStatisticsData2 = new TmfStatisticsTree();
        this.fStatisticsData3 = new TmfStatisticsTree();
        TmfStatisticsTreeManager.addStatsTreeRoot((String)this.fDataKey1, (TmfStatisticsTree)this.fStatisticsData1);
        TmfStatisticsTreeManager.addStatsTreeRoot((String)this.fDataKey2, (TmfStatisticsTree)this.fStatisticsData2);
        TmfStatisticsTreeManager.addStatsTreeRoot((String)this.fDataKey2, (TmfStatisticsTree)this.fStatisticsData3);
    }

    private static void removeStatsTreeRoot() {
        TmfStatisticsTreeManager.removeAll();
    }

    @Test
    public void testaddStatsTreeRoot() {
        TmfStatisticsTreeManagerTest.removeStatsTreeRoot();
        try {
            Assert.assertNull((Object)TmfStatisticsTreeManager.addStatsTreeRoot(null, null));
            Assert.assertNull((Object)TmfStatisticsTreeManager.addStatsTreeRoot(null, (TmfStatisticsTree)this.fStatisticsData1));
            Assert.assertNull((Object)TmfStatisticsTreeManager.addStatsTreeRoot((String)this.fDataKey1, null));
            Assert.assertNull((Object)TmfStatisticsTreeManager.getStatTreeRoot((String)this.fDataKey1));
            TmfStatisticsTreeNode returnRootNode = TmfStatisticsTreeManager.addStatsTreeRoot((String)this.fDataKey1, (TmfStatisticsTree)this.fStatisticsData1);
            Assert.assertSame((Object)this.fStatisticsData1, (Object)TmfStatisticsTreeManager.getStatTree((String)this.fDataKey1));
            Assert.assertSame((Object)this.fStatisticsData1.getRootNode(), (Object)returnRootNode);
            returnRootNode = TmfStatisticsTreeManager.addStatsTreeRoot((String)this.fDataKey1, (TmfStatisticsTree)this.fStatisticsData2);
            Assert.assertSame((Object)this.fStatisticsData2, (Object)TmfStatisticsTreeManager.getStatTree((String)this.fDataKey1));
            Assert.assertSame((Object)this.fStatisticsData2.getRootNode(), (Object)returnRootNode);
        }
        catch (Exception e) {
            Assert.fail((String)"AddStatsTreeRoot");
        }
    }

    @Test
    public void testGetStatTreeRoot() {
        TmfStatisticsTreeNode value1 = TmfStatisticsTreeManager.getStatTreeRoot((String)this.fDataKey1);
        TmfStatisticsTreeNode value2 = TmfStatisticsTreeManager.getStatTreeRoot((String)this.fDataKey2);
        TmfStatisticsTreeNode value3 = TmfStatisticsTreeManager.getStatTreeRoot((String)this.fDataKey1);
        Assert.assertNotSame((String)"getStatTreeRoot", (Object)value1, (Object)value2);
        Assert.assertNotSame((String)"getStatTreeRoot", (Object)value2, (Object)value3);
        Assert.assertSame((String)"getStatTreeRoot", (Object)value1, (Object)value3);
        Assert.assertNull((String)"getStatTreeRoot", (Object)TmfStatisticsTreeManager.getStatTreeRoot(null));
    }

    @Test
    public void testGetStatTree() {
        TmfStatisticsTree value1 = TmfStatisticsTreeManager.getStatTree((String)this.fDataKey1);
        TmfStatisticsTree value2 = TmfStatisticsTreeManager.getStatTree((String)this.fDataKey2);
        TmfStatisticsTree value3 = TmfStatisticsTreeManager.getStatTree((String)this.fDataKey1);
        Assert.assertNotSame((String)"getStatTree", (Object)value1, (Object)value2);
        Assert.assertNotSame((String)"getStatTree", (Object)value2, (Object)value3);
        Assert.assertSame((String)"getStatTree", (Object)value1, (Object)value3);
        Assert.assertNull((String)"getStatTreeRoot", (Object)TmfStatisticsTreeManager.getStatTree(null));
    }

    @Test
    public void testContainsTreeRoot() {
        Assert.assertTrue((String)"containsTreeRoot", (boolean)TmfStatisticsTreeManager.containsTreeRoot((String)this.fDataKey1));
        Assert.assertTrue((String)"containsTreeRoot", (boolean)TmfStatisticsTreeManager.containsTreeRoot((String)this.fDataKey2));
        Assert.assertFalse((String)"containsTreeRoot", (boolean)TmfStatisticsTreeManager.containsTreeRoot(null));
    }

    @Test
    public void testRemoveStatTreeRoot() {
        TmfStatisticsTreeManager.removeStatTreeRoot((String)this.fDataKey1);
        Assert.assertNull((String)"removeStatTreeRoot", (Object)TmfStatisticsTreeManager.getStatTree((String)this.fDataKey1));
        try {
            TmfStatisticsTreeManager.removeStatTreeRoot((String)this.fDataKey1);
            TmfStatisticsTreeManager.removeStatTreeRoot(null);
        }
        catch (Exception e) {
            Assert.fail((String)"removeStatTreeRoot");
        }
    }

    @Test
    public void testRemoveAll() {
        TmfStatisticsTreeManager.removeAll();
        Assert.assertNull((String)"removeAll", (Object)TmfStatisticsTreeManager.getStatTreeRoot((String)this.fDataKey2));
        Assert.assertNull((String)"removeAll", (Object)TmfStatisticsTreeManager.getStatTreeRoot((String)this.fDataKey3));
    }
}

