/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader.Uml2SDTestFacility;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.SyncMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.Criteria;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.FilterCriteria;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.loader.TmfSyncMessage;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TmfUml2SDSyncLoaderFilterTest {
    private static Uml2SDTestFacility fFacility;
    private static List<FilterCriteria> filterToSave;

    @BeforeClass
    public static void setUpClass() {
        fFacility = Uml2SDTestFacility.getInstance();
        fFacility.selectExperiment();
        filterToSave = new ArrayList<FilterCriteria>();
        Criteria criteria = new Criteria();
        criteria.setLifeLineSelected(true);
        criteria.setExpression("player1");
        filterToSave.add(new FilterCriteria(criteria, false, false));
        criteria = new Criteria();
        criteria.setLifeLineSelected(true);
        criteria.setExpression("Master");
        filterToSave.add(new FilterCriteria(criteria, false, false));
        criteria = new Criteria();
        criteria.setSyncMessageSelected(true);
        criteria.setExpression("BALL_.*");
        filterToSave.add(new FilterCriteria(criteria, false, false));
    }

    @AfterClass
    public static void tearDownClass() {
        fFacility.disposeExperiment();
        fFacility = null;
    }

    @Before
    public void beforeTest() {
        fFacility.firstPage();
    }

    @After
    public void afterTest() {
        filterToSave.get(0).setActive(false);
        filterToSave.get(1).setActive(false);
        filterToSave.get(2).setActive(false);
        fFacility.getLoader().filter(filterToSave);
        fFacility.delay(1000L);
    }

    @Test
    public void verifyFilter1of2() {
        filterToSave.get(0).setActive(true);
        fFacility.getLoader().filter(filterToSave);
        fFacility.delay(1000L);
        Assert.assertEquals((String)"filter", (long)1L, (long)fFacility.getSdView().getFrame().lifeLinesCount());
        Assert.assertEquals((String)"filter", (Object)"Master", (Object)fFacility.getSdView().getFrame().getLifeline(0).getName());
        Assert.assertEquals((String)"filter", (long)0L, (long)fFacility.getSdView().getFrame().syncMessageCount());
    }

    @Test
    public void verifyFilter2of2() {
        filterToSave.get(0).setActive(true);
        filterToSave.get(1).setActive(true);
        fFacility.getLoader().filter(filterToSave);
        fFacility.delay(1000L);
        Assert.assertEquals((String)"filter", (long)0L, (long)fFacility.getSdView().getFrame().lifeLinesCount());
        Assert.assertEquals((String)"filter", (long)0L, (long)fFacility.getSdView().getFrame().syncMessageCount());
    }

    @Test
    public void verifyRemoval() {
        filterToSave.get(0).setActive(true);
        filterToSave.get(1).setActive(true);
        fFacility.getLoader().filter(filterToSave);
        fFacility.delay(1000L);
        filterToSave.get(0).setActive(false);
        filterToSave.get(1).setActive(false);
        fFacility.getLoader().filter(filterToSave);
        fFacility.delay(1000L);
        Assert.assertEquals((String)"filter", (long)2L, (long)fFacility.getSdView().getFrame().lifeLinesCount());
        Assert.assertEquals((String)"filter", (long)10000L, (long)fFacility.getSdView().getFrame().syncMessageCount());
    }

    @Test
    public void verifyMessageFilter() {
        filterToSave.get(2).setActive(true);
        fFacility.getLoader().filter(filterToSave);
        fFacility.delay(1000L);
        Assert.assertEquals((String)"filter", (long)2L, (long)fFacility.getSdView().getFrame().lifeLinesCount());
        Assert.assertEquals((String)"filter", (long)6L, (long)fFacility.getSdView().getFrame().syncMessageCount());
        String[] messages = new String[]{"REGISTER_PLAYER_REQUEST", "REGISTER_PLAYER_REPLY", "GAME_REQUEST", "GAME_REPLY", "START_GAME_REQUEST", "START_GAME_REPLY"};
        int i = 0;
        while (i < messages.length) {
            SyncMessage msg = fFacility.getSdView().getFrame().getSyncMessage(i);
            Assert.assertTrue((String)"filter", (boolean)(msg instanceof TmfSyncMessage));
            Assert.assertEquals((String)"filter", (Object)messages[i], (Object)msg.getName());
            ++i;
        }
    }

    @Test
    public void verifyFilter1of3() {
        filterToSave.get(0).setActive(true);
        fFacility.getLoader().filter(filterToSave);
        fFacility.setPage(4);
        Assert.assertEquals((String)"filter", (long)2L, (long)fFacility.getSdView().getFrame().lifeLinesCount());
        String[] lifelines = new String[]{"Master", "player2"};
        int i = 0;
        while (i < lifelines.length) {
            Lifeline line = fFacility.getSdView().getFrame().getLifeline(i);
            Assert.assertEquals((String)"filter", (Object)lifelines[i], (Object)line.getName());
            ++i;
        }
        Assert.assertTrue((fFacility.getSdView().getFrame().syncMessageCount() > 0 ? 1 : 0) != 0);
    }
}

