/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.viewers.events.TmfEventsTable;
import org.osgi.framework.Bundle;

public final class TmfTraceTypeUIUtils {
    public static final String TMF_TRACE_TYPE_UI_ID = "org.eclipse.linuxtools.tmf.ui.tracetypeui";
    public static final String TYPE_ELEM = "type";
    public static final String EXPERIMENT_ELEM = "experiment";
    public static final String DEFAULT_EDITOR_ELEM = "defaultEditor";
    public static final String EVENTS_TABLE_TYPE_ELEM = "eventsTableType";
    public static final String EVENT_TABLE_COLUMNS = "eventTableColumns";
    public static final String TRACETYPE_ATTR = "tracetype";
    public static final String ICON_ATTR = "icon";
    public static final String CLASS_ATTR = "class";

    private TmfTraceTypeUIUtils() {
    }

    private static List<Pair<Integer, TraceTypeHelper>> reduce(List<Pair<Integer, TraceTypeHelper>> candidates) {
        ArrayList<Pair<Integer, TraceTypeHelper>> retVal = new ArrayList<Pair<Integer, TraceTypeHelper>>();
        for (Pair<Integer, TraceTypeHelper> candidatePair : candidates) {
            TraceTypeHelper candidate = (TraceTypeHelper)candidatePair.getSecond();
            if (!TmfTraceTypeUIUtils.isUnique(candidate, candidates)) continue;
            retVal.add(candidatePair);
        }
        return retVal;
    }

    private static boolean isUnique(TraceTypeHelper trace, List<Pair<Integer, TraceTypeHelper>> set) {
        if (trace.getTraceClass().equals(CustomTxtTrace.class) || trace.getTraceClass().equals(CustomXmlTrace.class)) {
            return true;
        }
        ITmfTrace tmfTrace = trace.getTrace();
        int count = -1;
        for (Pair<Integer, TraceTypeHelper> child : set) {
            ITmfTrace traceCandidate = ((TraceTypeHelper)child.getSecond()).getTrace();
            if (!tmfTrace.getClass().isInstance(traceCandidate)) continue;
            ++count;
        }
        return count == 0;
    }

    private static TraceTypeHelper getTraceTypeToSet(List<Pair<Integer, TraceTypeHelper>> candidates, Shell shell) {
        final HashMap<String, String> names = new HashMap<String, String>();
        Shell shellToShow = new Shell(shell);
        shellToShow.setText(Messages.TmfTraceType_SelectTraceType);
        final String[] candidatesToSet = new String[1];
        for (Pair<Integer, TraceTypeHelper> candidatePair : candidates) {
            TraceTypeHelper candidate = (TraceTypeHelper)candidatePair.getSecond();
            Button b = new Button((Composite)shellToShow, 16);
            String displayName = String.valueOf(candidate.getCategoryName()) + ':' + candidate.getName();
            b.setText(displayName);
            names.put(displayName, candidate.getTraceTypeId());
            b.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Button source = (Button)e.getSource();
                    candidatesToSet[0] = (String)names.get(source.getText());
                    source.getParent().dispose();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        shellToShow.setLayout((Layout)new RowLayout(512));
        shellToShow.pack();
        shellToShow.open();
        Display display = shellToShow.getDisplay();
        while (!shellToShow.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return TmfTraceType.getTraceType((String)candidatesToSet[0]);
    }

    public static TraceTypeHelper selectTraceType(String path, Shell shell, String traceTypeHint) throws TmfTraceImportException {
        Comparator<Pair<Integer, TraceTypeHelper>> comparator = new Comparator<Pair<Integer, TraceTypeHelper>>(){

            @Override
            public int compare(Pair<Integer, TraceTypeHelper> o1, Pair<Integer, TraceTypeHelper> o2) {
                int res = -((Integer)o1.getFirst()).compareTo((Integer)o2.getFirst());
                if (res == 0) {
                    res = ((TraceTypeHelper)o1.getSecond()).getName().compareTo(((TraceTypeHelper)o2.getSecond()).getName());
                }
                return res;
            }
        };
        TreeSet<Pair<Integer, TraceTypeHelper>> validCandidates = new TreeSet<Pair<Integer, TraceTypeHelper>>(comparator);
        Iterable traceTypeHelpers = TmfTraceType.getTraceTypeHelpers();
        for (TraceTypeHelper traceTypeHelper : traceTypeHelpers) {
            int confidence;
            if (traceTypeHelper.isExperimentType() || (confidence = traceTypeHelper.validateWithConfidence(path)) < 0) continue;
            Pair element = new Pair((Object)confidence, (Object)traceTypeHelper);
            validCandidates.add((Pair<Integer, TraceTypeHelper>)element);
        }
        TraceTypeHelper traceTypeToSet = null;
        if (validCandidates.isEmpty()) {
            File traceFile = new File(path);
            if (traceFile.isFile()) {
                return null;
            }
            String errorMsg = NLS.bind((String)Messages.TmfOpenTraceHelper_NoTraceTypeMatch, (Object)path);
            throw new TmfTraceImportException(errorMsg);
        }
        if (validCandidates.size() != 1) {
            ArrayList<Pair<Integer, TraceTypeHelper>> candidates = new ArrayList<Pair<Integer, TraceTypeHelper>>(validCandidates);
            List<Pair<Integer, TraceTypeHelper>> reducedCandidates = TmfTraceTypeUIUtils.reduce(candidates);
            for (Pair<Integer, TraceTypeHelper> candidatePair : reducedCandidates) {
                TraceTypeHelper candidate = (TraceTypeHelper)candidatePair.getSecond();
                if (!candidate.getTraceTypeId().equals(traceTypeHint)) continue;
                traceTypeToSet = candidate;
                break;
            }
            if (traceTypeToSet == null) {
                if (reducedCandidates.size() == 0) {
                    throw new TmfTraceImportException(Messages.TmfOpenTraceHelper_ReduceError);
                }
                if (reducedCandidates.size() == 1) {
                    if ((Integer)reducedCandidates.get(0).getFirst() > 0) {
                        traceTypeToSet = (TraceTypeHelper)reducedCandidates.get(0).getSecond();
                    }
                } else if (shell == null) {
                    Pair<Integer, TraceTypeHelper> candidate = reducedCandidates.get(0);
                    if ((Integer)candidate.getFirst() > 0) {
                        traceTypeToSet = (TraceTypeHelper)candidate.getSecond();
                    }
                } else {
                    traceTypeToSet = TmfTraceTypeUIUtils.getTraceTypeToSet(reducedCandidates, shell);
                }
            }
        } else if ((Integer)validCandidates.first().getFirst() > 0) {
            traceTypeToSet = (TraceTypeHelper)validCandidates.first().getSecond();
        }
        return traceTypeToSet;
    }

    public static IStatus setTraceType(IResource resource, TraceTypeHelper traceType) throws CoreException {
        return TmfTraceTypeUIUtils.setTraceType(resource, traceType, true);
    }

    public static IStatus setTraceType(IResource resource, TraceTypeHelper traceType, boolean refresh) throws CoreException {
        String traceTypeId = traceType.getTraceTypeId();
        resource.setPersistentProperty(TmfCommonConstants.TRACETYPE, traceTypeId);
        TmfProjectElement tmfProject = TmfProjectRegistry.getProject(resource.getProject(), true);
        if (tmfProject.getTracesFolder().getPath().isPrefixOf(resource.getFullPath())) {
            String elementPath = resource.getFullPath().makeRelativeTo(tmfProject.getTracesFolder().getPath()).toString();
            TmfTraceTypeUIUtils.refreshTraceElement(tmfProject.getTracesFolder().getTraces(), elementPath);
        } else if (resource.getParent().equals((Object)tmfProject.getExperimentsFolder().getResource())) {
            for (TmfExperimentElement experimentElement : tmfProject.getExperimentsFolder().getExperiments()) {
                if (!resource.equals((Object)experimentElement.getResource())) continue;
                experimentElement.refreshTraceType();
                break;
            }
        } else {
            for (TmfExperimentElement experimentElement : tmfProject.getExperimentsFolder().getExperiments()) {
                if (!experimentElement.getPath().isPrefixOf(resource.getFullPath())) continue;
                String elementPath = resource.getFullPath().makeRelativeTo(experimentElement.getPath()).toString();
                TmfTraceTypeUIUtils.refreshTraceElement(experimentElement.getTraces(), elementPath);
                break;
            }
        }
        if (refresh) {
            tmfProject.refresh();
        }
        return Status.OK_STATUS;
    }

    private static void refreshTraceElement(List<TmfTraceElement> traceElements, String elementPath) {
        for (TmfTraceElement traceElement : traceElements) {
            if (!traceElement.getElementPath().equals(elementPath)) continue;
            traceElement.refreshTraceType();
            break;
        }
    }

    public static IConfigurationElement[] getTypeUIElements(TmfTraceType.TraceElementType elType) {
        String elementName = TYPE_ELEM;
        if (elType == TmfTraceType.TraceElementType.EXPERIMENT) {
            elementName = EXPERIMENT_ELEM;
        }
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_TRACE_TYPE_UI_ID);
        LinkedList<IConfigurationElement> typeElements = new LinkedList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(elementName)) {
                typeElements.add(element);
            }
            ++n2;
        }
        return typeElements.toArray(new IConfigurationElement[typeElements.size()]);
    }

    @Nullable
    public static IConfigurationElement getTraceUIAttributes(String traceType, TmfTraceType.TraceElementType elType) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = TmfTraceTypeUIUtils.getTypeUIElements(elType);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (traceType.equals(ce.getAttribute(TRACETYPE_ATTR))) {
                return ce;
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    public static TmfEventsTable getEventTable(ITmfTrace trace, Composite parent, int cacheSize) {
        String traceType = TmfTraceTypeUIUtils.getTraceType(trace);
        if (traceType == null) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = TmfTraceTypeUIUtils.getTypeUIElements(TmfTraceType.TraceElementType.TRACE);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (ce.getAttribute(TRACETYPE_ATTR).equals(traceType)) {
                String eventsTableType;
                IConfigurationElement[] eventsTableTypeCE = ce.getChildren(EVENTS_TABLE_TYPE_ELEM);
                if (eventsTableTypeCE.length != 1 || (eventsTableType = eventsTableTypeCE[0].getAttribute(CLASS_ATTR)).isEmpty()) break;
                try {
                    Bundle bundle = Platform.getBundle((String)ce.getContributor().getName());
                    Class c = bundle.loadClass(eventsTableType);
                    Class[] constructorArgs = new Class[]{Composite.class, Integer.TYPE};
                    Constructor constructor = c.getConstructor(constructorArgs);
                    Object[] args = new Object[]{parent, cacheSize};
                    return (TmfEventsTable)constructor.newInstance(args);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    private static String getTraceType(ITmfTrace trace) {
        IResource res = trace.getResource();
        if (res == null) {
            return null;
        }
        try {
            String traceType = res.getPersistentProperty(TmfCommonConstants.TRACETYPE);
            return traceType;
        }
        catch (CoreException e) {
            return null;
        }
    }
}

