/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.swtchart.IAxis;
import org.swtchart.ICustomPaintListener;
import org.swtchart.IPlotArea;

public class TmfMouseSelectionProvider
extends TmfBaseProvider
implements MouseListener,
MouseMoveListener,
ICustomPaintListener {
    private long fBeginTime;
    private long fEndTime;
    private boolean fIsInternalUpdate;

    public TmfMouseSelectionProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
        this.register();
    }

    @Override
    public void register() {
        this.getChart().getPlotArea().addMouseListener((MouseListener)this);
        this.getChart().getPlotArea().addMouseMoveListener((MouseMoveListener)this);
        ((IPlotArea)this.getChart().getPlotArea()).addCustomPaintListener((ICustomPaintListener)this);
    }

    @Override
    public void deregister() {
        if (this.getChartViewer().getControl() != null && !this.getChartViewer().getControl().isDisposed()) {
            this.getChart().getPlotArea().removeMouseListener((MouseListener)this);
            this.getChart().getPlotArea().removeMouseMoveListener((MouseMoveListener)this);
            ((IPlotArea)this.getChart().getPlotArea()).removeCustomPaintListener((ICustomPaintListener)this);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (this.getChartViewer().getWindowDuration() != 0L && e.button == 1) {
            IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
            this.fEndTime = this.fBeginTime = this.limitXDataCoordinate(xAxis.getDataCoordinate(e.x));
            this.fIsInternalUpdate = true;
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.fIsInternalUpdate) {
            if (this.fBeginTime > this.fEndTime) {
                long tmp = this.fBeginTime;
                this.fBeginTime = this.fEndTime;
                this.fEndTime = tmp;
            }
            ITmfChartTimeProvider viewer = this.getChartViewer();
            viewer.updateSelectionRange(this.fBeginTime + viewer.getTimeOffset(), this.fEndTime + viewer.getTimeOffset());
            this.fIsInternalUpdate = false;
            this.getChart().redraw();
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.fIsInternalUpdate) {
            IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
            this.fEndTime = this.limitXDataCoordinate(xAxis.getDataCoordinate(e.x));
            this.getChart().redraw();
        }
    }

    public void paintControl(PaintEvent e) {
        int beginX;
        ITmfChartTimeProvider viewer = this.getChartViewer();
        if (!this.fIsInternalUpdate) {
            this.fBeginTime = viewer.getSelectionBeginTime() - viewer.getTimeOffset();
            this.fEndTime = viewer.getSelectionEndTime() - viewer.getTimeOffset();
        }
        long windowStartTime = viewer.getWindowStartTime() - viewer.getTimeOffset();
        long windowEndTime = viewer.getWindowEndTime() - viewer.getTimeOffset();
        IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
        e.gc.setBackground(TmfXYChartViewer.getDisplay().getSystemColor(9));
        e.gc.setForeground(TmfXYChartViewer.getDisplay().getSystemColor(9));
        e.gc.setLineStyle(1);
        if (this.fBeginTime >= windowStartTime && this.fBeginTime <= windowEndTime) {
            beginX = xAxis.getPixelCoordinate((double)this.fBeginTime);
            e.gc.drawLine(beginX, 0, beginX, e.height);
        }
        if (this.fEndTime >= windowStartTime && this.fEndTime <= windowEndTime && this.fBeginTime != this.fEndTime) {
            int endX = xAxis.getPixelCoordinate((double)this.fEndTime);
            e.gc.drawLine(endX, 0, endX, e.height);
        }
        e.gc.setAlpha(150);
        if (Math.abs(this.fEndTime - this.fBeginTime) > 1L) {
            e.gc.setBackground(TmfXYChartViewer.getDisplay().getSystemColor(22));
            beginX = xAxis.getPixelCoordinate((double)this.fBeginTime);
            int endX = xAxis.getPixelCoordinate((double)this.fEndTime);
            if (this.fEndTime > this.fBeginTime) {
                e.gc.fillRectangle(beginX + 1, 0, endX - beginX - 1, e.height);
            } else {
                e.gc.fillRectangle(endX + 1, 0, beginX - endX - 1, e.height);
            }
        }
    }

    public boolean drawBehindSeries() {
        return false;
    }
}

