/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.AsyncMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.AsyncMessageReturn;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.BaseMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.BasicExecutionOccurrence;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.BasicFrame;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.ExecutionOccurrence;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.ITimeRange;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.LifelineCategories;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.SDTimeEvent;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.SyncMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.SyncMessageReturn;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.IColor;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.preferences.SDViewPref;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.util.TimeEventComparator;

public class Frame
extends BasicFrame {
    private Lifeline fHighlightLifeline = null;
    private int fStartEvent = 0;
    private int fNbEvent = 0;
    private IColor fHighlightColor = null;
    private List<SDTimeEvent> fExecutionOccurrencesWithTime;
    private LifelineCategories[] fLifelineCategories = null;

    protected List<GraphNode> getLifelines() {
        if (!this.hasChildren()) {
            return null;
        }
        return this.getNodeMap().get("Lifeline");
    }

    public int lifeLinesCount() {
        List<GraphNode> lifelines = this.getLifelines();
        if (lifelines != null) {
            return lifelines.size();
        }
        return 0;
    }

    public Lifeline getLifeline(int index) {
        if (this.getLifelines() != null && index >= 0 && index < this.lifeLinesCount()) {
            return (Lifeline)this.getLifelines().get(index);
        }
        return null;
    }

    protected List<GraphNode> getSyncMessages() {
        if (!this.hasChildren()) {
            return null;
        }
        return this.getNodeMap().get("SyncMessage");
    }

    public int syncMessageCount() {
        if (this.getSyncMessages() != null) {
            return this.getSyncMessages().size();
        }
        return 0;
    }

    public SyncMessage getSyncMessage(int index) {
        if (this.getSyncMessages() != null && index >= 0 && index < this.getSyncMessages().size()) {
            return (SyncMessage)this.getSyncMessages().get(index);
        }
        return null;
    }

    protected List<GraphNode> getAsyncMessages() {
        if (!this.hasChildren()) {
            return null;
        }
        return this.getNodeMap().get("AsyncMessage");
    }

    public int asyncMessageCount() {
        if (this.getAsyncMessages() != null) {
            return this.getAsyncMessages().size();
        }
        return 0;
    }

    public AsyncMessage getAsyncMessage(int index) {
        if (this.getAsyncMessages() != null && index >= 0 && index < this.getAsyncMessages().size()) {
            return (AsyncMessage)this.getAsyncMessages().get(index);
        }
        return null;
    }

    protected List<GraphNode> getSyncMessagesReturn() {
        if (!this.hasChildren()) {
            return null;
        }
        return this.getNodeMap().get("SyncMessageRet");
    }

    public int syncMessageReturnCount() {
        if (this.getSyncMessagesReturn() != null) {
            return this.getSyncMessagesReturn().size();
        }
        return 0;
    }

    public SyncMessageReturn getSyncMessageReturn(int index) {
        if (this.getSyncMessagesReturn() != null && index >= 0 && index < this.getSyncMessagesReturn().size()) {
            return (SyncMessageReturn)this.getSyncMessagesReturn().get(index);
        }
        return null;
    }

    protected List<GraphNode> getAsyncMessagesReturn() {
        if (!this.hasChildren()) {
            return null;
        }
        return this.getNodeMap().get("AsyncMessageRet");
    }

    public int asyncMessageReturnCount() {
        if (this.getAsyncMessagesReturn() != null) {
            return this.getAsyncMessagesReturn().size();
        }
        return 0;
    }

    public AsyncMessageReturn getAsyncMessageReturn(int index) {
        if (this.getAsyncMessagesReturn() != null && index >= 0 && index < this.getAsyncMessagesReturn().size()) {
            return (AsyncMessageReturn)this.getAsyncMessagesReturn().get(index);
        }
        return null;
    }

    public void addLifeLine(Lifeline lifeline) {
        this.setComputeMinMax(true);
        if (lifeline == null) {
            return;
        }
        lifeline.setFrame(this);
        lifeline.setIndex(this.getNewHorizontalIndex());
        if (lifeline.hasTimeInfo()) {
            this.setHasTimeInfo(true);
        }
        this.addNode(lifeline);
    }

    public int getFirstVisibleLifeline() {
        if (!this.hasChildren()) {
            return 0;
        }
        if (this.getIndexes().get("Lifeline") != null) {
            return this.getIndexes().get("Lifeline");
        }
        return 0;
    }

    public int getFirstVisibleSyncMessage() {
        if (!this.hasChildren()) {
            return 0;
        }
        if (this.getIndexes().get("SyncMessage") != null) {
            return this.getIndexes().get("SyncMessage");
        }
        return 0;
    }

    public int getFirstVisibleSyncMessageReturn() {
        if (!this.hasChildren()) {
            return 0;
        }
        if (this.getIndexes().get("SyncMessageRet") != null) {
            return this.getIndexes().get("SyncMessageRet");
        }
        return 0;
    }

    public int getFirstVisibleAsyncMessage() {
        if (!this.hasChildren()) {
            return 0;
        }
        if (this.getIndexes().get("AsyncMessage") != null) {
            return this.getIndexes().get("AsyncMessage");
        }
        return 0;
    }

    public int getFirstVisibleAsyncMessageReturn() {
        if (!this.hasChildren()) {
            return 0;
        }
        if (this.getIndexes().get("AsyncMessageRet") != null) {
            return this.getIndexes().get("AsyncMessageRet");
        }
        return 0;
    }

    public List<SDTimeEvent> getExecutionOccurrencesWithTime() {
        return this.fExecutionOccurrencesWithTime;
    }

    public void insertLifelineAfter(Lifeline toInsert, Lifeline after) {
        int removePoint;
        if (toInsert == null) {
            return;
        }
        if (toInsert == after) {
            return;
        }
        int insertPoint = 0;
        if (after != null) {
            insertPoint = after.getIndex();
        }
        if ((removePoint = toInsert.getIndex() - 1) >= insertPoint) {
            this.getLifelines().remove(removePoint);
        }
        this.getLifelines().add(insertPoint, toInsert);
        if (removePoint < insertPoint) {
            this.getLifelines().remove(removePoint);
        }
        if (removePoint >= insertPoint) {
            toInsert.setIndex(insertPoint + 1);
        } else {
            toInsert.setIndex(insertPoint - 1);
        }
        if (removePoint >= ++insertPoint) {
            int i = insertPoint;
            while (i < this.getLifelines().size()) {
                this.getLifeline(i).setIndex(i + 1);
                ++i;
            }
        } else {
            int i = 0;
            while (i < insertPoint && i < this.getLifelines().size()) {
                this.getLifeline(i).setIndex(i + 1);
                ++i;
            }
        }
    }

    public void insertLifelineBefore(Lifeline toInsert, Lifeline before) {
        int removePoint;
        if (toInsert == null) {
            return;
        }
        if (toInsert == before) {
            return;
        }
        int insertPoint = 0;
        if (before != null) {
            insertPoint = before.getIndex() - 1;
        }
        if ((removePoint = toInsert.getIndex() - 1) >= insertPoint) {
            this.getLifelines().remove(removePoint);
        }
        this.getLifelines().add(insertPoint, toInsert);
        if (removePoint < insertPoint) {
            this.getLifelines().remove(removePoint);
        }
        if (removePoint >= insertPoint) {
            toInsert.setIndex(insertPoint + 1);
        } else {
            toInsert.setIndex(insertPoint - 1);
        }
        if (removePoint >= ++insertPoint) {
            int i = insertPoint;
            while (i < this.getLifelines().size()) {
                this.getLifeline(i).setIndex(i + 1);
                ++i;
            }
        } else {
            int i = 0;
            while (i < insertPoint && i < this.getLifelines().size()) {
                this.getLifeline(i).setIndex(i + 1);
                ++i;
            }
        }
    }

    public Lifeline getCloserLifeline(int x) {
        int dist3;
        Lifeline node3;
        int index = (x - 10 + 23) / Metrics.swimmingLaneWidth() - 1;
        if (index < 0) {
            index = 0;
        }
        if (index >= this.getLifelines().size()) {
            index = this.getLifelines().size() - 1;
        }
        Lifeline node2 = node3 = this.getLifeline(index);
        Lifeline node1 = node3;
        int dist2 = dist3 = Math.abs(node1.getX() + node1.getWidth() / 2 - x);
        int dist1 = dist3;
        if (index > 0) {
            node2 = this.getLifeline(index - 1);
            dist2 = Math.abs(node2.getX() + node2.getWidth() / 2 - x);
        }
        if (index < this.getLifelines().size() - 1) {
            node3 = this.getLifeline(index + 1);
            dist3 = Math.abs(node3.getX() + node3.getWidth() / 2 - x);
        }
        if (dist1 <= dist2 && dist1 <= dist3) {
            return node1;
        }
        if (dist2 <= dist1 && dist2 <= dist3) {
            return node2;
        }
        return node3;
    }

    public void reorder(List<?> list) {
        int i = 0;
        while (i < list.size()) {
            Lifeline[] temp;
            if (list.get(i) instanceof Lifeline[] && (temp = (Lifeline[])list.get(i)).length == 2) {
                if (temp[1] == null) {
                    this.insertLifelineAfter(temp[0], this.getLifeline(this.lifeLinesCount() - 1));
                } else {
                    this.insertLifelineBefore(temp[0], temp[1]);
                }
            }
            ++i;
        }
    }

    public void resetTimeCompression() {
        this.fHighlightLifeline = null;
        this.fStartEvent = 0;
        this.fNbEvent = 0;
        this.fHighlightColor = null;
    }

    @Override
    protected void computeMinMax() {
        List<SDTimeEvent> timeArray = this.buildTimeArray();
        if (timeArray == null || timeArray.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < timeArray.size() - 1) {
            block6: {
                SDTimeEvent m2;
                SDTimeEvent m1;
                block5: {
                    m1 = timeArray.get(i);
                    m2 = timeArray.get(i + 1);
                    if (!SDViewPref.getInstance().excludeExternalTime() || !(m1.getGraphNode() instanceof BaseMessage) || !(m2.getGraphNode() instanceof BaseMessage)) break block5;
                    BaseMessage mes1 = (BaseMessage)((Object)m1.getGraphNode());
                    BaseMessage mes2 = (BaseMessage)((Object)m2.getGraphNode());
                    if (mes2.getStartLifeline() == null || mes1.getEndLifeline() == null) break block6;
                }
                this.updateMinMax(m1, m2);
            }
            ++i;
        }
    }

    public boolean findDateBounds(ITmfTimestamp dateToFind, ITimeRange[] bounds) {
        if (this.hasTimeInfo()) {
            List<SDTimeEvent> timeArray = this.buildTimeArray();
            if (timeArray == null || timeArray.isEmpty()) {
                return false;
            }
            bounds[0] = null;
            bounds[1] = null;
            int i = 0;
            while (i < timeArray.size()) {
                SDTimeEvent m = timeArray.get(i);
                if (m.getTime().compareTo(dateToFind) > 0) {
                    bounds[1] = m.getGraphNode();
                    if (i > 0) {
                        bounds[0] = timeArray.get(i - 1).getGraphNode();
                        return true;
                    }
                    return false;
                }
                ++i;
            }
            bounds[0] = timeArray.get(timeArray.size() - 1).getGraphNode();
        }
        return false;
    }

    public void highlightTimeCompression(Lifeline lifeline, int startEvent, int nbEvent, IColor color) {
        this.fHighlightLifeline = lifeline;
        this.fStartEvent = startEvent;
        this.fNbEvent = nbEvent;
        this.fHighlightColor = color;
    }

    public void setLifelineCategories(LifelineCategories[] categories) {
        this.fLifelineCategories = Arrays.copyOf(categories, categories.length);
    }

    public LifelineCategories[] getLifelineCategories() {
        return Arrays.copyOf(this.fLifelineCategories, this.fLifelineCategories.length);
    }

    public void addMessage(BaseMessage message) {
        this.addNode(message);
    }

    @Override
    public void draw(IGC context) {
        int lifeLineDrawIndex;
        this.drawFrame(context);
        if (!this.hasChildren()) {
            return;
        }
        if (this.fHighlightLifeline != null) {
            IColor backupColor = context.getBackground();
            context.setBackground(SDViewPref.getInstance().getTimeCompressionSelectionColor());
            int gy = this.fHighlightLifeline.getY() + this.fHighlightLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.fStartEvent;
            context.fillRectangle(11, gy, this.fHighlightLifeline.getX() + Metrics.getLifelineWidth() / 2 - 10, (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.fNbEvent);
            context.setBackground(backupColor);
        }
        super.draw(context, false);
        int lifelineArryStep = 1;
        if ((float)Metrics.swimmingLaneWidth() * context.getZoom() < 10.0f) {
            lifelineArryStep = Math.round(10.0f / ((float)Metrics.swimmingLaneWidth() * context.getZoom()));
        }
        if (this.getIndexes().size() == 0) {
            return;
        }
        int i = lifeLineDrawIndex = this.getIndexes().get("Lifeline").intValue();
        while (i < this.getNodeMap().get("Lifeline").size()) {
            Lifeline toDraw = (Lifeline)this.getNodeMap().get("Lifeline").get(i);
            if (toDraw.getX() - 22 > context.getContentsX() + context.getVisibleWidth()) break;
            toDraw.drawName(context);
            if (this.fHighlightLifeline != null) {
                if (toDraw == this.fHighlightLifeline) {
                    toDraw.highlightExecOccurrenceRegion(context, this.fStartEvent, this.fNbEvent, this.fHighlightColor);
                } else if (toDraw.getIndex() < this.fHighlightLifeline.getIndex()) {
                    int acIndex = toDraw.getExecOccurrenceDrawIndex();
                    if (toDraw.getExecutions() != null) {
                        int index = acIndex;
                        while (index < toDraw.getExecutions().size()) {
                            BasicExecutionOccurrence exec = (BasicExecutionOccurrence)toDraw.getExecutions().get(index);
                            int tempEvent = this.fStartEvent;
                            int j = 0;
                            while (j < this.fNbEvent) {
                                if (tempEvent >= exec.getStartOccurrence() && tempEvent <= exec.getEndOccurrence() && tempEvent + 1 >= exec.getStartOccurrence() && tempEvent + 1 <= exec.getEndOccurrence()) {
                                    toDraw.highlightExecOccurrenceRegion(context, tempEvent, 1, SDViewPref.getInstance().getTimeCompressionSelectionColor());
                                }
                                ++tempEvent;
                                ++j;
                            }
                            if (exec.getY() > this.getY()) break;
                            ++index;
                        }
                    }
                }
            }
            i += lifelineArryStep;
        }
    }

    @Override
    protected List<SDTimeEvent> buildTimeArray() {
        if (!this.hasChildren()) {
            return new ArrayList<SDTimeEvent>();
        }
        List<SDTimeEvent> timeArray = super.buildTimeArray();
        this.fExecutionOccurrencesWithTime = null;
        if (this.getLifelines() != null) {
            int i = 0;
            while (i < this.getNodeMap().get("Lifeline").size()) {
                Lifeline lifeline = (Lifeline)this.getNodeMap().get("Lifeline").get(i);
                if (lifeline.hasTimeInfo() && lifeline.getExecutions() != null) {
                    for (GraphNode o : lifeline.getExecutions()) {
                        ExecutionOccurrence eo;
                        if (!(o instanceof ExecutionOccurrence) || !(eo = (ExecutionOccurrence)o).hasTimeInfo()) continue;
                        int event = eo.getStartOccurrence();
                        ITmfTimestamp time = eo.getStartTime();
                        SDTimeEvent f = new SDTimeEvent(time, event, eo);
                        timeArray.add(f);
                        if (this.fExecutionOccurrencesWithTime == null) {
                            this.fExecutionOccurrencesWithTime = new ArrayList<SDTimeEvent>();
                        }
                        this.fExecutionOccurrencesWithTime.add(f);
                        event = eo.getEndOccurrence();
                        time = eo.getEndTime();
                        f = new SDTimeEvent(time, event, eo);
                        timeArray.add(f);
                        this.fExecutionOccurrencesWithTime.add(f);
                    }
                }
                ++i;
            }
        }
        if (this.fExecutionOccurrencesWithTime != null) {
            SDTimeEvent[] temp = this.fExecutionOccurrencesWithTime.toArray(new SDTimeEvent[this.fExecutionOccurrencesWithTime.size()]);
            Arrays.sort(temp, new TimeEventComparator());
            this.fExecutionOccurrencesWithTime = Arrays.asList(temp);
        }
        SDTimeEvent[] temp = timeArray.toArray(new SDTimeEvent[timeArray.size()]);
        Arrays.sort(temp, new TimeEventComparator());
        timeArray = Arrays.asList(temp);
        return timeArray;
    }

    protected GraphNode getCloserLeavingMessage(Lifeline lifeline, BaseMessage message, List<GraphNode> list, boolean smallerEvent) {
        if (list == null) {
            return null;
        }
        if (!smallerEvent) {
            int event = 0;
            if (message != null) {
                event = message.getEventOccurrence();
            }
            int i = 0;
            while (i < list.size()) {
                AsyncMessage asyncNode;
                SyncMessage syncNode;
                GraphNode node = list.get(i);
                if (node instanceof SyncMessage ? (syncNode = (SyncMessage)node).getEventOccurrence() > event && syncNode.getStartLifeline() == lifeline && !syncNode.isSameAs(message) : node instanceof AsyncMessage && (asyncNode = (AsyncMessage)node).getStartOccurrence() > event && asyncNode.getStartLifeline() == lifeline && !asyncNode.isSameAs(message)) {
                    return node;
                }
                ++i;
            }
        } else {
            int event = this.getMaxEventOccurrence();
            if (message != null) {
                event = message instanceof AsyncMessage ? ((AsyncMessage)message).getStartOccurrence() : message.getEventOccurrence();
            }
            int i = list.size() - 1;
            while (i >= 0) {
                AsyncMessage asyncNode;
                SyncMessage syncNode;
                GraphNode node = list.get(i);
                if (node instanceof SyncMessage ? (syncNode = (SyncMessage)node).getEventOccurrence() < event && syncNode.getStartLifeline() == lifeline && !syncNode.isSameAs(message) : node instanceof AsyncMessage && (asyncNode = (AsyncMessage)node).getStartOccurrence() < event && asyncNode.getStartLifeline() == lifeline && !asyncNode.isSameAs(message)) {
                    return node;
                }
                --i;
            }
        }
        return null;
    }

    protected GraphNode getCloserEnteringMessage(Lifeline lifeline, BaseMessage message, List<GraphNode> list, boolean smallerEvent) {
        if (list == null) {
            return null;
        }
        if (!smallerEvent) {
            int event = 0;
            if (message != null) {
                event = message.getEventOccurrence();
            }
            int i = 0;
            while (i < list.size()) {
                AsyncMessage asyncNode;
                SyncMessage syncNode;
                GraphNode node = list.get(i);
                if (node instanceof SyncMessage ? (syncNode = (SyncMessage)node).getEventOccurrence() > event && syncNode.getEndLifeline() == lifeline && !syncNode.isSameAs(message) : node instanceof AsyncMessage && (asyncNode = (AsyncMessage)node).getStartOccurrence() > event && asyncNode.getEndLifeline() == lifeline && !asyncNode.isSameAs(message)) {
                    return node;
                }
                ++i;
            }
        } else {
            int event = this.getMaxEventOccurrence();
            if (message != null) {
                event = message instanceof AsyncMessage ? ((AsyncMessage)message).getStartOccurrence() : message.getEventOccurrence();
            }
            int i = list.size() - 1;
            while (i >= 0) {
                AsyncMessage asyncNode;
                SyncMessage syncNode;
                GraphNode node = list.get(i);
                if (node instanceof SyncMessage ? (syncNode = (SyncMessage)node).getEventOccurrence() < event && syncNode.getEndLifeline() == lifeline && !syncNode.isSameAs(message) : node instanceof AsyncMessage && (asyncNode = (AsyncMessage)node).getStartOccurrence() < event && asyncNode.getEndLifeline() == lifeline && !asyncNode.isSameAs(message)) {
                    return node;
                }
                --i;
            }
        }
        return null;
    }

    protected int distanceFromEvent(GraphNode node, int event) {
        int distance = 0;
        if (node instanceof SyncMessage) {
            distance = ((SyncMessage)node).getEventOccurrence() - event;
        } else if (node instanceof AsyncMessage) {
            int end;
            int start = ((AsyncMessage)node).getStartOccurrence();
            distance = start - event < (end = ((AsyncMessage)node).getEndOccurrence()) - event ? start - event : end - event;
        }
        return Math.abs(distance);
    }

    protected GraphNode getCloserToEvent(GraphNode node1, GraphNode node2, int event) {
        if (node1 != null && node2 != null) {
            if (this.distanceFromEvent(node1, event) < this.distanceFromEvent(node2, event)) {
                return node1;
            }
            return node2;
        }
        if (node1 != null) {
            return node1;
        }
        if (node2 != null) {
            return node2;
        }
        return null;
    }

    public GraphNode getCalledMessage(BaseMessage startMessage) {
        int event = 0;
        GraphNode result = null;
        Lifeline lifeline = null;
        if (startMessage != null) {
            event = startMessage.getEventOccurrence();
            lifeline = startMessage.getEndLifeline();
            if (lifeline == null) {
                lifeline = startMessage.getStartLifeline();
            }
        }
        if (lifeline == null) {
            return null;
        }
        GraphNode message = this.getCloserLeavingMessage(lifeline, startMessage, this.getSyncMessages(), false);
        GraphNode messageReturn = this.getCloserLeavingMessage(lifeline, startMessage, this.getSyncMessagesReturn(), false);
        result = this.getCloserToEvent(message, messageReturn, event);
        message = this.getCloserLeavingMessage(lifeline, startMessage, this.getAsyncMessages(), false);
        result = this.getCloserToEvent(result, message, event);
        messageReturn = this.getCloserLeavingMessage(lifeline, startMessage, this.getAsyncMessagesReturn(), false);
        result = this.getCloserToEvent(result, messageReturn, event);
        return result;
    }

    public GraphNode getCallerMessage(BaseMessage startMessage) {
        int event = this.getMaxEventOccurrence();
        GraphNode result = null;
        Lifeline lifeline = null;
        if (startMessage != null) {
            event = startMessage.getEventOccurrence();
            lifeline = startMessage.getStartLifeline();
            if (lifeline == null) {
                lifeline = startMessage.getEndLifeline();
            }
        }
        if (lifeline == null) {
            return null;
        }
        GraphNode message = this.getCloserEnteringMessage(lifeline, startMessage, this.getSyncMessages(), true);
        GraphNode messageReturn = this.getCloserEnteringMessage(lifeline, startMessage, this.getSyncMessagesReturn(), true);
        result = this.getCloserToEvent(message, messageReturn, event);
        message = this.getCloserEnteringMessage(lifeline, startMessage, this.getAsyncMessages(), true);
        result = this.getCloserToEvent(result, message, event);
        messageReturn = this.getCloserEnteringMessage(lifeline, startMessage, this.getAsyncMessagesReturn(), true);
        result = this.getCloserToEvent(result, messageReturn, event);
        return result;
    }

    public GraphNode getNextLifelineMessage(Lifeline lifeline, BaseMessage startMessage) {
        int event = 0;
        if (startMessage != null) {
            event = startMessage.getEventOccurrence();
        }
        if (lifeline == null) {
            return null;
        }
        GraphNode message = this.getCloserLeavingMessage(lifeline, startMessage, this.getSyncMessages(), false);
        GraphNode messageReturn = this.getCloserLeavingMessage(lifeline, startMessage, this.getSyncMessagesReturn(), false);
        GraphNode result = this.getCloserToEvent(message, messageReturn, event);
        message = this.getCloserLeavingMessage(lifeline, startMessage, this.getAsyncMessages(), false);
        result = this.getCloserToEvent(result, message, event);
        messageReturn = this.getCloserLeavingMessage(lifeline, startMessage, this.getAsyncMessagesReturn(), false);
        result = this.getCloserToEvent(result, messageReturn, event);
        return result;
    }

    public GraphNode getPrevLifelineMessage(Lifeline lifeline, BaseMessage startMessage) {
        int event = this.getMaxEventOccurrence();
        if (startMessage != null) {
            event = startMessage instanceof AsyncMessage ? ((AsyncMessage)startMessage).getStartOccurrence() : startMessage.getEventOccurrence();
        }
        if (lifeline == null) {
            return null;
        }
        GraphNode message = this.getCloserLeavingMessage(lifeline, startMessage, this.getSyncMessages(), true);
        GraphNode messageReturn = this.getCloserLeavingMessage(lifeline, startMessage, this.getSyncMessagesReturn(), true);
        GraphNode result = this.getCloserToEvent(message, messageReturn, event);
        message = this.getCloserLeavingMessage(lifeline, startMessage, this.getAsyncMessages(), true);
        result = this.getCloserToEvent(result, message, event);
        messageReturn = this.getCloserLeavingMessage(lifeline, startMessage, this.getAsyncMessagesReturn(), true);
        result = this.getCloserToEvent(result, messageReturn, event);
        return result;
    }

    public BasicExecutionOccurrence getFirstExecution(Lifeline lifeline) {
        if (lifeline == null) {
            return null;
        }
        List<GraphNode> list = lifeline.getExecutions();
        if (list == null || list.isEmpty()) {
            return null;
        }
        BasicExecutionOccurrence result = (BasicExecutionOccurrence)list.get(0);
        int i = 0;
        while (i < list.size()) {
            BasicExecutionOccurrence e = (BasicExecutionOccurrence)list.get(i);
            if (e.getStartOccurrence() < result.getEndOccurrence()) {
                result = e;
            }
            ++i;
        }
        return result;
    }

    public BasicExecutionOccurrence getPrevExecOccurrence(BasicExecutionOccurrence exec) {
        if (exec == null) {
            return null;
        }
        Lifeline lifeline = exec.getLifeline();
        if (lifeline == null) {
            return null;
        }
        List<GraphNode> list = lifeline.getExecutions();
        if (list == null) {
            return null;
        }
        BasicExecutionOccurrence result = null;
        int i = 0;
        while (i < list.size()) {
            BasicExecutionOccurrence e = (BasicExecutionOccurrence)list.get(i);
            if (e.getStartOccurrence() < exec.getStartOccurrence() && result == null) {
                result = e;
            }
            if (e.getStartOccurrence() < exec.getStartOccurrence() && result != null && e.getStartOccurrence() >= result.getEndOccurrence()) {
                result = e;
            }
            ++i;
        }
        return result;
    }

    public BasicExecutionOccurrence getNextExecOccurrence(BasicExecutionOccurrence exec) {
        if (exec == null) {
            return null;
        }
        Lifeline lifeline = exec.getLifeline();
        if (lifeline == null) {
            return null;
        }
        List<GraphNode> list = lifeline.getExecutions();
        if (list == null) {
            return null;
        }
        BasicExecutionOccurrence result = null;
        int i = 0;
        while (i < list.size()) {
            BasicExecutionOccurrence e = (BasicExecutionOccurrence)list.get(i);
            if (e.getStartOccurrence() > exec.getStartOccurrence() && result == null) {
                result = e;
            }
            if (e.getStartOccurrence() > exec.getStartOccurrence() && result != null && e.getStartOccurrence() <= result.getEndOccurrence()) {
                result = e;
            }
            ++i;
        }
        return result;
    }

    public BasicExecutionOccurrence getLastExecOccurrence(Lifeline lifeline) {
        if (lifeline == null) {
            return null;
        }
        List<GraphNode> list = lifeline.getExecutions();
        if (list == null) {
            return null;
        }
        BasicExecutionOccurrence result = null;
        int i = 0;
        while (i < list.size()) {
            BasicExecutionOccurrence e = (BasicExecutionOccurrence)list.get(i);
            if (result == null) {
                result = e;
            }
            if (e.getStartOccurrence() > result.getEndOccurrence()) {
                result = e;
            }
            ++i;
        }
        return result;
    }

    protected Lifeline getHighlightLifeline() {
        return this.fHighlightLifeline;
    }

    protected int getStartEvent() {
        return this.fStartEvent;
    }

    protected int getNumberOfEvents() {
        return this.fNbEvent;
    }

    protected IColor getHighlightColor() {
        return this.fHighlightColor;
    }

    protected void setHighlightLifeline(Lifeline lifeline) {
        this.fHighlightLifeline = lifeline;
    }

    protected void setStartEvent(int startEvent) {
        this.fStartEvent = startEvent;
    }

    protected void setNumberOfEvents(int nbEvents) {
        this.fNbEvent = nbEvents;
    }

    protected void setHighlightColor(IColor color) {
        this.fHighlightColor = color;
    }

    protected void setExecutionOccurrencesWithTime(List<SDTimeEvent> occurences) {
        this.fExecutionOccurrencesWithTime = occurences;
    }
}

