/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.tests.analysis.memory;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.memory.UstMemoryAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisRequirement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UstMemoryAnalysisModuleTest {
    private UstMemoryAnalysisModule fUstAnalysisModule;

    @Before
    public void setup() {
        this.fUstAnalysisModule = new UstMemoryAnalysisModule();
    }

    @Test
    public void testGetAnalysisRequirements() {
        Iterable requirements = this.fUstAnalysisModule.getAnalysisRequirements();
        Assert.assertNotNull((Object)requirements);
        Assert.assertTrue((boolean)requirements.iterator().hasNext());
        TmfAnalysisRequirement eventReq = null;
        TmfAnalysisRequirement domainReq = null;
        int numberOfRequirement = 0;
        for (TmfAnalysisRequirement requirement : requirements) {
            ++numberOfRequirement;
            if (requirement.getType().equals("event")) {
                eventReq = requirement;
                continue;
            }
            if (!requirement.getType().equals("domain")) continue;
            domainReq = requirement;
        }
        Assert.assertNotNull(eventReq);
        Assert.assertNotNull(domainReq);
        Assert.assertEquals((long)2L, (long)numberOfRequirement);
        Assert.assertEquals((long)1L, (long)domainReq.getValues().size());
        for (String domain : domainReq.getValues()) {
            Assert.assertEquals((Object)"UST", (Object)domain);
        }
        ImmutableSet expectedEvents = ImmutableSet.of((Object)"ust_libc:malloc", (Object)"ust_libc:free", (Object)"ust_libc:calloc", (Object)"ust_libc:realloc", (Object)"ust_libc:memalign", (Object)"ust_libc:posix_memalign", (Object[])new String[0]);
        Assert.assertEquals((long)6L, (long)eventReq.getValues().size());
        for (String event : eventReq.getValues()) {
            Assert.assertTrue((String)("Unexpected event " + event), (boolean)expectedEvents.contains(event));
        }
        Set infos = eventReq.getInformation();
        Assert.assertEquals((long)2L, (long)infos.size());
    }
}

