/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.tests.callstack;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.core.callstack.LttngUstCallStackProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public abstract class AbstractProviderTest {
    @Rule
    public TestRule globalTimeout = new Timeout(20L, TimeUnit.SECONDS);
    private static final CtfTmfTestTrace otherUstTrace = CtfTmfTestTrace.HELLO_LOST;
    private CtfTmfTrace fTrace = null;
    private ITmfStateSystem fSS = null;
    private TestLttngCallStackModule fModule;

    protected abstract CtfTmfTestTrace getTestTrace();

    protected abstract String getProcName();

    protected abstract long getTestTimestamp(int var1);

    @Before
    public void setUp() {
        CtfTmfTrace trace;
        CtfTmfTestTrace testTrace = this.getTestTrace();
        this.fTrace = trace = testTrace.getTrace();
        this.fModule = new TestLttngCallStackModule();
        try {
            Assert.assertTrue((boolean)this.fModule.setTrace((ITmfTrace)trace));
        }
        catch (TmfAnalysisException e) {
            Assert.fail();
        }
        this.fModule.schedule();
        Assert.assertTrue((boolean)this.fModule.waitForCompletion());
        this.fSS = this.fModule.getStateSystem();
        Assert.assertNotNull((Object)this.fSS);
    }

    @After
    public void tearDown() {
        this.fModule.dispose();
        if (this.fTrace != null) {
            this.fTrace.dispose();
            File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)this.fTrace));
            AbstractProviderTest.deleteDirectory(suppDir);
        }
    }

    @Test
    public void testOtherUstTrace() {
        File suppDir;
        Throwable throwable = null;
        Object var3_3 = null;
        try (CtfTmfTrace ustTrace = otherUstTrace.getTrace();){
            TestLttngCallStackModule module = null;
            try {
                module = new TestLttngCallStackModule();
                try {
                    Assert.assertTrue((boolean)module.setTrace((ITmfTrace)ustTrace));
                }
                catch (TmfAnalysisException e) {
                    Assert.fail();
                }
                module.schedule();
                Assert.assertTrue((boolean)module.waitForCompletion());
                ITmfStateSystem ss = module.getStateSystem();
                Assert.assertNotNull((Object)ss);
                Assert.assertTrue((ss.getStartTime() >= ustTrace.getStartTime().normalize(0L, -9).getValue() ? 1 : 0) != 0);
                Assert.assertEquals((long)0L, (long)ss.getNbAttributes());
            }
            finally {
                if (module != null) {
                    module.dispose();
                }
            }
            suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)ustTrace));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        AbstractProviderTest.deleteDirectory(suppDir);
        Assert.assertFalse((boolean)suppDir.exists());
    }

    @Test
    public void testConstruction() {
        Assert.assertNotNull((Object)this.fSS);
        Assert.assertTrue((this.fSS.getNbAttributes() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCallStackBegin() {
        long start = this.fSS.getStartTime();
        String[] cs = AbstractProviderTest.getCallStack(this.fSS, this.getProcName(), start);
        Assert.assertEquals((long)1L, (long)cs.length);
        Assert.assertEquals((Object)"40472b", (Object)cs[0]);
    }

    @Test
    public void testCallStack1() {
        String[] cs = AbstractProviderTest.getCallStack(this.fSS, this.getProcName(), this.getTestTimestamp(0));
        Assert.assertEquals((long)2L, (long)cs.length);
        Assert.assertEquals((Object)"40472b", (Object)cs[0]);
        Assert.assertEquals((Object)"403d60", (Object)cs[1]);
    }

    @Test
    public void testCallStack2() {
        String[] cs = AbstractProviderTest.getCallStack(this.fSS, this.getProcName(), this.getTestTimestamp(1));
        Assert.assertEquals((long)3L, (long)cs.length);
        Assert.assertEquals((Object)"40472b", (Object)cs[0]);
        Assert.assertEquals((Object)"403b14", (Object)cs[1]);
        Assert.assertEquals((Object)"401b23", (Object)cs[2]);
    }

    @Test
    public void testCallStack3() {
        String[] cs = AbstractProviderTest.getCallStack(this.fSS, this.getProcName(), this.getTestTimestamp(2));
        Assert.assertEquals((long)4L, (long)cs.length);
        Assert.assertEquals((Object)"40472b", (Object)cs[0]);
        Assert.assertEquals((Object)"4045c8", (Object)cs[1]);
        Assert.assertEquals((Object)"403760", (Object)cs[2]);
        Assert.assertEquals((Object)"401aac", (Object)cs[3]);
    }

    @Test
    public void testCallStackEnd() {
        long end = this.fSS.getCurrentEndTime();
        String[] cs = AbstractProviderTest.getCallStack(this.fSS, this.getProcName(), end);
        Assert.assertEquals((long)3L, (long)cs.length);
        Assert.assertEquals((Object)"40472b", (Object)cs[0]);
        Assert.assertEquals((Object)"4045c8", (Object)cs[1]);
        Assert.assertEquals((Object)"403760", (Object)cs[2]);
    }

    private static void deleteDirectory(File dir) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
        dir.delete();
    }

    private static String[] getCallStack(ITmfStateSystem ss, String processName, long timestamp) {
        try {
            int stackAttribute = ss.getQuarkAbsolute(new String[]{"Threads", processName, "CallStack"});
            List state = ss.queryFullState(timestamp);
            int depth = ((ITmfStateInterval)state.get(stackAttribute)).getStateValue().unboxInt();
            int stackTop = ss.getQuarkRelative(stackAttribute, new String[]{String.valueOf(depth)});
            ITmfStateValue expectedValue = ((ITmfStateInterval)state.get(stackTop)).getStateValue();
            ITmfStateInterval interval = StateSystemUtils.querySingleStackTop((ITmfStateSystem)ss, (long)timestamp, (int)stackAttribute);
            Assert.assertNotNull((Object)interval);
            Assert.assertEquals((Object)expectedValue, (Object)interval.getStateValue());
            String[] ret = new String[depth];
            int i = 0;
            while (i < depth) {
                int quark = ss.getQuarkRelative(stackAttribute, new String[]{String.valueOf(i + 1)});
                ret[i] = ((ITmfStateInterval)state.get(quark)).getStateValue().unboxStr();
                ++i;
            }
            return ret;
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateSystemDisposedException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.fail();
        return null;
    }

    private class TestLttngCallStackModule
    extends TmfStateSystemAnalysisModule {
        private TestLttngCallStackModule() {
        }

        protected ITmfStateProvider createStateProvider() {
            return new LttngUstCallStackProvider((ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace()));
        }
    }
}

