/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.perf.trace;

import java.io.IOException;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PcapReadBenchmark {
    private static final String TEST_SUITE_NAME = "Pcap Read Benchmark";
    private static final String TEST_ID = "org.eclipse.linuxtools#Pcap Read Benchmark";
    private static final int LOOP_COUNT = 25;
    private static final int RUN_BETWEEN_COMMIT_COUNT = 15;

    @Test
    public void testPcapTrace() {
        PcapReadBenchmark.readTrace(PcapTestTrace.BENCHMARK_TRACE, "trace-pcap", true);
    }

    /*
     * Unable to fully structure code
     */
    private static void readTrace(PcapTestTrace testTrace, String testName, boolean inGlobalSummary) {
        Assume.assumeTrue((boolean)testTrace.exists());
        perf = Performance.getDefault();
        pm = perf.createPerformanceMeter("org.eclipse.linuxtools#Pcap Read Benchmark#" + testName);
        perf.tagAsSummary(pm, "Pcap Read Benchmark:" + testName, Dimension.CPU_TIME);
        if (inGlobalSummary) {
            perf.tagAsGlobalSummary(pm, "Pcap Read Benchmark:" + testName, Dimension.CPU_TIME);
        }
        loop = 0;
        while (loop < 25) {
            pm.start();
            try {
                var6_6 = null;
                var7_9 = null;
                try {
                    trace = testTrace.getTrace();
                    try {
                        i = 0;
                        while (true) {
                            trace.seekPacket(0L);
                            while (trace.hasNextPacket()) {
                                packet = trace.parseNextPacket();
                                if (packet == null) {
                                    Assert.fail((String)("Test failed at iteration " + loop + '.' + i + ", at packet " + trace.getCurrentRank()));
                                    return;
                                }
                                packet.getPayload();
                            }
                            ++i;
                            break;
                        }
                    }
                    finally {
                        if (i < 15) ** continue;
                    }
                }
                catch (Throwable var7_10) {
                    if (var6_6 == null) {
                        var6_6 = var7_10;
                    } else if (var6_6 != var7_10) {
                        var6_6.addSuppressed(var7_10);
                    }
                    throw var6_6;
                }
            }
            catch (IOException | BadPacketException | BadPcapFileException e) {
                Assert.fail((String)("Test failed at iteration " + loop + ':' + e.getMessage()));
            }
            pm.stop();
            ++loop;
        }
        pm.commit();
    }
}

