/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.protocol.udp;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.udp.UDPEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.udp.UDPPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class UDPPacketTest {
    private static final Map<String, String> EXPECTED_FIELDS = ImmutableMap.of((Object)"Source Port", (Object)"18057", (Object)"Destination Port", (Object)"39611", (Object)"Length", (Object)"41452 bytes", (Object)"Checksum", (Object)"0xfaaf");
    private static final String EXPTECTED_TOSTRING;
    private ByteBuffer fPacket;

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("User Datagram Protocol, Source Port: 18057, Destination Port: 39611, Length: 41452, Checksum: 64175\n");
        sb.append("Payload: 99 88 77 66");
        EXPTECTED_TOSTRING = sb.toString();
    }

    @Before
    public void initialize() {
        this.fPacket = ByteBuffer.allocate(12);
        this.fPacket.order(ByteOrder.BIG_ENDIAN);
        this.fPacket.put((byte)70);
        this.fPacket.put((byte)-119);
        this.fPacket.put((byte)-102);
        this.fPacket.put((byte)-69);
        this.fPacket.put((byte)-95);
        this.fPacket.put((byte)-20);
        this.fPacket.put((byte)-6);
        this.fPacket.put((byte)-81);
        this.fPacket.put((byte)-103);
        this.fPacket.put((byte)-120);
        this.fPacket.put((byte)119);
        this.fPacket.put((byte)102);
        this.fPacket.flip();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void CompleteUDPPacketTest() throws IOException, BadPcapFileException, BadPacketException {
        PcapTestTrace trace = PcapTestTrace.MOSTLY_TCP;
        Assume.assumeTrue((boolean)trace.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            PcapFile dummy = new PcapFile(trace.getPath());
            try {
                ByteBuffer byteBuffer = this.fPacket;
                if (byteBuffer == null) {
                    Assert.fail((String)"CompleteUDPPacketTest has failed!");
                    return;
                }
                UDPPacket packet = new UDPPacket(dummy, null, byteBuffer);
                Assert.assertEquals((Object)PcapProtocol.UDP, (Object)packet.getProtocol());
                Assert.assertTrue((boolean)packet.hasProtocol(PcapProtocol.UDP));
                Assert.assertTrue((boolean)packet.hasProtocol(PcapProtocol.UNKNOWN));
                Assert.assertFalse((boolean)packet.hasProtocol(PcapProtocol.ETHERNET_II));
                Assert.assertTrue((boolean)packet.validate());
                Assert.assertEquals((long)473000225L, (long)packet.hashCode());
                Assert.assertFalse((boolean)packet.equals(null));
                Assert.assertEquals((Object)new UDPPacket(dummy, null, byteBuffer), (Object)packet);
                Assert.assertEquals(EXPECTED_FIELDS, (Object)packet.getFields());
                Assert.assertEquals((Object)EXPTECTED_TOSTRING, (Object)packet.toString());
                Assert.assertEquals((Object)"Src Port: 18057, Dst Port: 39611", (Object)packet.getLocalSummaryString());
                Assert.assertEquals((Object)"Source Port: 18057, Destination Port: 39611", (Object)packet.getGlobalSummaryString());
                Assert.assertEquals((Object)new UDPEndpoint(packet, true), (Object)packet.getSourceEndpoint());
                Assert.assertEquals((Object)new UDPEndpoint(packet, false), (Object)packet.getDestinationEndpoint());
                this.fPacket.position(8);
                byte[] payload = new byte[4];
                this.fPacket.get(payload);
                Assert.assertEquals((Object)ByteBuffer.wrap(payload), (Object)packet.getPayload());
                Assert.assertEquals((long)18057L, (long)packet.getSourcePort());
                Assert.assertEquals((long)39611L, (long)packet.getDestinationPort());
                Assert.assertEquals((long)41452L, (long)packet.getTotalLength());
                Assert.assertEquals((long)64175L, (long)packet.getChecksum());
                return;
            }
            finally {
                if (dummy == null) return;
                dummy.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

