/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.kernel.statesystem;

import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelAnalysisModule;
import org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.kernel.statesystem.StateSystemTest;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class StateSystemInMemoryTest
extends StateSystemTest {
    private static TestLttngKernelAnalysisModule module;

    @BeforeClass
    public static void initialize() {
        if (!testTrace.exists()) {
            traceIsPresent = false;
            return;
        }
        traceIsPresent = true;
        module = new TestLttngKernelAnalysisModule();
        try {
            Assert.assertTrue((boolean)module.setTrace((ITmfTrace)testTrace.getTrace()));
        }
        catch (TmfAnalysisException e) {
            Assert.fail();
        }
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
        fixture = module.getStateSystem();
    }

    @AfterClass
    public static void cleanup() {
        if (module != null) {
            module.dispose();
        }
        if (fixture != null) {
            fixture.dispose();
        }
        module = null;
        fixture = null;
    }

    private static class TestLttngKernelAnalysisModule
    extends KernelAnalysisModule {
        public boolean setTrace(ITmfTrace trace) throws TmfAnalysisException {
            if (!(trace instanceof CtfTmfTrace)) {
                return false;
            }
            return super.setTrace(trace);
        }

        protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
            return TmfStateSystemAnalysisModule.StateSystemBackendType.INMEM;
        }
    }
}

