/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.event.matchandsync;

import org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching.TcpEventMatching;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching.TcpLttngEventMatching;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.synchronization.SynchronizationAlgorithm;
import org.eclipse.tracecompass.tmf.core.synchronization.TimestampTransformFactory;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExperimentSyncTest {
    private static final String EXPERIMENT = "MyExperiment";
    private static int BLOCK_SIZE = 1000;

    @BeforeClass
    public static void setUp() {
        TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)new TcpEventMatching());
        TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)new TcpLttngEventMatching());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testExperimentSync() {
        Assume.assumeTrue((boolean)CtfTmfTestTrace.SYNC_SRC.exists());
        Assume.assumeTrue((boolean)CtfTmfTestTrace.SYNC_DEST.exists());
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            CtfTmfTrace trace1 = CtfTmfTestTrace.SYNC_SRC.getTrace();
            try {
                try (CtfTmfTrace trace2 = CtfTmfTestTrace.SYNC_DEST.getTrace();){
                    ITmfTrace[] traces = new ITmfTrace[]{trace1, trace2};
                    TmfExperiment experiment = new TmfExperiment(traces[0].getEventType(), EXPERIMENT, traces, BLOCK_SIZE, null);
                    SynchronizationAlgorithm syncAlgo = experiment.synchronizeTraces(true);
                    ITmfTimestampTransform tt1 = syncAlgo.getTimestampTransform((ITmfTrace)trace1);
                    ITmfTimestampTransform tt2 = syncAlgo.getTimestampTransform((ITmfTrace)trace2);
                    trace1.setTimestampTransform(tt1);
                    trace2.setTimestampTransform(tt2);
                    Assert.assertEquals((Object)"TmfTimestampTransformLinearFast [ slope = 0.9999413783703139011056845831168394, offset = 79796507913179.33347660124688298171 ]", (Object)tt1.toString());
                    Assert.assertEquals((Object)TimestampTransformFactory.getDefaultTransform(), (Object)tt2);
                    Assert.assertEquals((Object)syncAlgo.getTimestampTransform(trace1.getHostId()), (Object)trace1.getTimestampTransform());
                    Assert.assertEquals((Object)syncAlgo.getTimestampTransform(trace2.getHostId()), (Object)trace2.getTimestampTransform());
                }
                if (trace1 == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (trace1 == null) throw throwable;
                trace1.close();
                throw throwable;
            }
            trace1.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testDjangoExperimentSync() {
        Assume.assumeTrue((boolean)CtfTmfTestTrace.DJANGO_CLIENT.exists());
        Assume.assumeTrue((boolean)CtfTmfTestTrace.DJANGO_DB.exists());
        Assume.assumeTrue((boolean)CtfTmfTestTrace.DJANGO_HTTPD.exists());
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            CtfTmfTrace trace1 = CtfTmfTestTrace.DJANGO_CLIENT.getTrace();
            try {
                block18: {
                    CtfTmfTrace trace2 = CtfTmfTestTrace.DJANGO_DB.getTrace();
                    try {
                        try (CtfTmfTrace trace3 = CtfTmfTestTrace.DJANGO_HTTPD.getTrace();){
                            ITmfTrace[] traces = new ITmfTrace[]{trace1, trace2, trace3};
                            TmfExperiment experiment = new TmfExperiment(traces[0].getEventType(), EXPERIMENT, traces, BLOCK_SIZE, null);
                            SynchronizationAlgorithm syncAlgo = experiment.synchronizeTraces(true);
                            ITmfTimestampTransform tt1 = syncAlgo.getTimestampTransform((ITmfTrace)trace1);
                            ITmfTimestampTransform tt2 = syncAlgo.getTimestampTransform((ITmfTrace)trace2);
                            ITmfTimestampTransform tt3 = syncAlgo.getTimestampTransform((ITmfTrace)trace3);
                            trace1.setTimestampTransform(tt1);
                            trace2.setTimestampTransform(tt2);
                            trace3.setTimestampTransform(tt3);
                            Assert.assertEquals((Object)TimestampTransformFactory.getDefaultTransform(), (Object)tt1);
                            Assert.assertEquals((Object)"TmfTimestampTransformLinearFast [ slope = 0.9999996313017589597204633828681240, offset = 498490309972.0038068817738527724192 ]", (Object)tt2.toString());
                            Assert.assertEquals((Object)"TmfTimestampTransformLinearFast [ slope = 1.000000119014882262265342419815932, offset = -166652893534.6189900382736187431134 ]", (Object)tt3.toString());
                        }
                        if (trace2 == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (trace2 == null) throw throwable;
                        trace2.close();
                        throw throwable;
                    }
                    trace2.close();
                }
                if (trace1 == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (trace1 == null) throw throwable;
                trace1.close();
                throw throwable;
            }
            trace1.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }
}

