/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.event.matchandsync;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching.TcpEventMatching;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching.TcpLttngEventMatching;
import org.eclipse.tracecompass.tmf.core.event.matching.IMatchProcessingUnit;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class MatchAndSyncTest {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testMatching() {
        Assume.assumeTrue((boolean)CtfTmfTestTrace.SYNC_SRC.exists());
        Assume.assumeTrue((boolean)CtfTmfTestTrace.SYNC_DEST.exists());
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            CtfTmfTrace trace1 = CtfTmfTestTrace.SYNC_SRC.getTrace();
            try {
                try (CtfTmfTrace trace2 = CtfTmfTestTrace.SYNC_DEST.getTrace();){
                    LinkedList<CtfTmfTrace> tracearr = new LinkedList<CtfTmfTrace>();
                    tracearr.add(trace1);
                    tracearr.add(trace2);
                    TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)new TcpEventMatching());
                    TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)new TcpLttngEventMatching());
                    TmfEventMatching twoTraceMatch = new TmfEventMatching(tracearr);
                    Assert.assertTrue((boolean)twoTraceMatch.matchEvents());
                    try {
                        Method method = TmfEventMatching.class.getDeclaredMethod("getProcessingUnit", new Class[0]);
                        method.setAccessible(true);
                        IMatchProcessingUnit procUnit = (IMatchProcessingUnit)method.invoke((Object)twoTraceMatch, new Object[0]);
                        Assert.assertEquals((long)46L, (long)procUnit.countMatches());
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
                if (trace1 == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (trace1 == null) throw throwable;
                trace1.close();
                throw throwable;
            }
            trace1.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

