/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.event.matching;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching.TcpEventMatching;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching.TcpLttngEventMatching;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class EventMatchingBenchmark {
    private static final String TEST_ID = "org.eclipse.linuxtools#Event matching#";
    private static final String TIME = " (time)";
    private static final String MEMORY = " (memory usage)";
    private static final String TEST_SUMMARY = "Event matching";

    @BeforeClass
    public static void setUp() {
        TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)new TcpEventMatching());
        TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)new TcpLttngEventMatching());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testSmallTraces() {
        Assume.assumeTrue((boolean)CtfTmfTestTrace.SYNC_SRC.exists());
        Assume.assumeTrue((boolean)CtfTmfTestTrace.SYNC_DEST.exists());
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            CtfTmfTrace trace1 = CtfTmfTestTrace.SYNC_SRC.getTrace();
            try {
                try (CtfTmfTrace trace2 = CtfTmfTestTrace.SYNC_DEST.getTrace();){
                    ImmutableSet traces = ImmutableSet.of((Object)trace1, (Object)trace2);
                    EventMatchingBenchmark.runCpuTest((Set<ITmfTrace>)traces, "Match TCP events", 100);
                }
                if (trace1 == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (trace1 == null) throw throwable;
                trace1.close();
                throw throwable;
            }
            trace1.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testDjangoTraces() {
        Assume.assumeTrue((boolean)CtfTmfTestTrace.DJANGO_CLIENT.exists());
        Assume.assumeTrue((boolean)CtfTmfTestTrace.DJANGO_DB.exists());
        Assume.assumeTrue((boolean)CtfTmfTestTrace.DJANGO_HTTPD.exists());
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            CtfTmfTrace trace1 = CtfTmfTestTrace.DJANGO_CLIENT.getTrace();
            try {
                block18: {
                    CtfTmfTrace trace2 = CtfTmfTestTrace.DJANGO_DB.getTrace();
                    try {
                        try (CtfTmfTrace trace3 = CtfTmfTestTrace.DJANGO_HTTPD.getTrace();){
                            ImmutableSet traces = ImmutableSet.of((Object)trace1, (Object)trace2, (Object)trace3);
                            EventMatchingBenchmark.runCpuTest((Set<ITmfTrace>)traces, "Django traces", 10);
                            EventMatchingBenchmark.runMemoryTest((Set<ITmfTrace>)traces, "Django traces", 10);
                        }
                        if (trace2 == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (trace2 == null) throw throwable;
                        trace2.close();
                        throw throwable;
                    }
                    trace2.close();
                }
                if (trace1 == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (trace1 == null) throw throwable;
                trace1.close();
                throw throwable;
            }
            trace1.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    private static void runCpuTest(Set<ITmfTrace> testTraces, String testName, int loop_count) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter(TEST_ID + testName + TIME);
        perf.tagAsSummary(pm, "Event matching:" + testName + TIME, Dimension.CPU_TIME);
        int i = 0;
        while (i < loop_count) {
            TmfEventMatching traceMatch = new TmfEventMatching(testTraces);
            pm.start();
            traceMatch.matchEvents();
            pm.stop();
            ++i;
        }
        pm.commit();
    }

    private static void runMemoryTest(Set<ITmfTrace> testTraces, String testName, int loop_count) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter(TEST_ID + testName + MEMORY);
        perf.tagAsSummary(pm, "Event matching:" + testName + MEMORY, Dimension.USED_JAVA_HEAP);
        int i = 0;
        while (i < loop_count) {
            TmfEventMatching traceMatch = new TmfEventMatching(testTraces);
            System.gc();
            pm.start();
            traceMatch.matchEvents();
            System.gc();
            pm.stop();
            ++i;
        }
        pm.commit();
    }
}

