/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.ui.swtbot.tests;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.BatchImportTraceWizard;
import org.eclipse.tracecompass.tmf.ctf.ui.swtbot.tests.AbstractImportAndReadSmokeTest;
import org.eclipse.tracecompass.tmf.ui.editors.TmfEventsEditor;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ImportAndReadSmokeTest
extends AbstractImportAndReadSmokeTest {
    private static final String TRACE_PROJECT_NAME = "test";

    @Test
    public void test() {
        this.createProject();
        ImportAndReadSmokeTest.batchImportOpenWizard();
        ImportAndReadSmokeTest.batchImportSelecTraceType();
        ImportAndReadSmokeTest.batchImportAddDirectory();
        ImportAndReadSmokeTest.batchImportSelectTrace();
        this.importFinish();
        TmfEventsEditor tmfEd = SWTBotUtils.openEditor((SWTWorkbenchBot)fBot, (String)this.getProjectName(), (IPath)new Path("scp_dest"));
        this.testHistogramView(this.getViewPart("Histogram"), tmfEd);
        this.testPropertyView(this.getViewPart("Properties"));
        this.testStatisticsView(this.getViewPart("Statistics"));
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject((String)this.getProjectName(), (SWTWorkbenchBot)fBot);
    }

    private static void batchImportOpenWizard() {
        fWizard = new BatchImportTraceWizard();
        UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench != null) {
                    IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                    Shell shell = activeWorkbenchWindow.getShell();
                    Assert.assertNotNull((Object)shell);
                    ((BatchImportTraceWizard)fWizard).init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)fWizard);
                    dialog.open();
                }
            }
        });
        fBot.waitUntil(ConditionHelpers.isWizardReady((Wizard)fWizard));
    }

    private static void batchImportSelecTraceType() {
        SWTBotTree tree = fBot.tree();
        String ctfId = "Common Trace Format";
        fBot.waitUntil(ConditionHelpers.IsTreeNodeAvailable((String)"Common Trace Format", (SWTBotTree)tree));
        fBot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable((String)"Generic CTF Trace", (SWTBotTreeItem)tree.getTreeItem("Common Trace Format")));
        tree.getTreeItem("Common Trace Format").getNode("Generic CTF Trace").check();
        ImportAndReadSmokeTest.batchImportClickNext();
    }

    private static void batchImportAddDirectory() {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                ((BatchImportTraceWizard)fWizard).addFileToScan(fTrace.getPath());
            }
        });
        SWTBotButton removeButton = fBot.button("Remove");
        fBot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)removeButton));
        removeButton.click();
        fBot.waitUntil(Conditions.tableHasRows((SWTBotTable)fBot.table(), (int)1));
        ImportAndReadSmokeTest.batchImportClickNext();
    }

    private static void batchImportSelectTrace() {
        SWTBotTree tree = fBot.tree();
        fBot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)tree));
        SWTBotTreeItem genericCtfTreeItem = tree.getTreeItem("Generic CTF Trace");
        fBot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)genericCtfTreeItem));
        genericCtfTreeItem.expand();
        genericCtfTreeItem.check();
        ImportAndReadSmokeTest.batchImportClickNext();
    }

    private static void batchImportClickNext() {
        IWizardPage currentPage = fWizard.getContainer().getCurrentPage();
        IWizardPage desiredPage = fWizard.getNextPage(currentPage);
        SWTBotButton nextButton = fBot.button("Next >");
        nextButton.click();
        fBot.waitUntil(ConditionHelpers.isWizardOnPage((Wizard)fWizard, (IWizardPage)desiredPage));
    }

    @Override
    protected String getProjectName() {
        return TRACE_PROJECT_NAME;
    }
}

