/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.parsers.wizards;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.tmf.core.parsers.custom.CustomEventAspects;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.parsers.wizards.CustomTxtParserWizard;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpointIndexer;
import org.eclipse.tracecompass.tmf.ui.viewers.events.TmfEventsTable;

public class CustomTxtParserOutputWizardPage
extends WizardPage {
    private static final Image UP_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/up_button.gif");
    private static final Image DOWN_IMAGE = Activator.getDefault().getImageFromPath("/icons/elcl16/down_button.gif");
    private final CustomTxtParserWizard wizard;
    private CustomTxtTraceDefinition definition;
    private List<Output> outputs = new ArrayList<Output>();
    private Composite container;
    private SashForm sash;
    private ScrolledComposite outputsScrolledComposite;
    private Composite outputsContainer;
    private Composite tableContainer;
    private TmfEventsTable previewTable;
    private File tmpFile;

    protected CustomTxtParserOutputWizardPage(CustomTxtParserWizard wizard) {
        super("CustomParserOutputWizardPage");
        this.setTitle(wizard.inputPage.getTitle());
        this.setDescription(Messages.CustomTxtParserOutputWizardPage_description);
        this.wizard = wizard;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        this.sash = new SashForm(this.container, 512);
        this.sash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sash.setBackground(this.sash.getDisplay().getSystemColor(15));
        this.outputsScrolledComposite = new ScrolledComposite((Composite)this.sash, 512);
        this.outputsScrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.outputsContainer = new Composite((Composite)this.outputsScrolledComposite, 0);
        GridLayout outputsLayout = new GridLayout(4, false);
        outputsLayout.marginHeight = 10;
        outputsLayout.marginWidth = 0;
        this.outputsContainer.setLayout((Layout)outputsLayout);
        this.outputsScrolledComposite.setContent((Control)this.outputsContainer);
        this.outputsScrolledComposite.setExpandHorizontal(true);
        this.outputsScrolledComposite.setExpandVertical(true);
        this.outputsContainer.layout();
        this.outputsScrolledComposite.setMinSize(this.outputsContainer.computeSize((int)-1, (int)-1).x, this.outputsContainer.computeSize((int)-1, (int)-1).y - 5);
        this.tableContainer = new Composite((Composite)this.sash, 0);
        GridLayout tableLayout = new GridLayout();
        tableLayout.marginHeight = 0;
        tableLayout.marginWidth = 0;
        this.tableContainer.setLayout((Layout)tableLayout);
        this.previewTable = new TmfEventsTable(this.tableContainer, 0, CustomEventAspects.generateAspects((CustomTraceDefinition)new CustomTxtTraceDefinition()));
        this.previewTable.setLayoutData(new GridData(4, 4, true, true));
        if (this.wizard.definition != null) {
            this.loadDefinition(this.wizard.definition);
        }
        this.setControl((Control)this.container);
    }

    public void dispose() {
        this.previewTable.dispose();
        super.dispose();
    }

    private void loadDefinition(CustomTxtTraceDefinition def) {
        for (CustomTraceDefinition.OutputColumn outputColumn : def.outputs) {
            Output output = new Output(this.outputsContainer, outputColumn.name);
            this.outputs.add(output);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.definition = this.wizard.inputPage.getDefinition();
            List<String> outputNames = this.wizard.inputPage.getInputNames();
            Iterator<Output> iter = this.outputs.iterator();
            while (iter.hasNext()) {
                Output output = iter.next();
                boolean found = false;
                for (String name : outputNames) {
                    if (!output.name.equals(name)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                output.dispose();
                iter.remove();
            }
            for (String name : outputNames) {
                boolean found = false;
                for (Output output : this.outputs) {
                    if (!output.name.equals(name)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.outputs.add(new Output(this.outputsContainer, name));
            }
            this.outputsContainer.layout();
            this.outputsScrolledComposite.setMinSize(this.outputsContainer.computeSize((int)-1, (int)-1).x, this.outputsContainer.computeSize((int)-1, (int)-1).y - 5);
            this.updatePreviewTable();
            if (this.sash.getSize().y > this.outputsContainer.computeSize((int)-1, (int)-1).y + this.previewTable.getTable().getItemHeight()) {
                this.sash.setWeights(new int[]{this.outputsContainer.computeSize((int)-1, (int)-1).y, this.sash.getSize().y - this.outputsContainer.computeSize((int)-1, (int)-1).y});
            } else {
                this.sash.setWeights(new int[]{this.outputsContainer.computeSize((int)-1, (int)-1).y, this.previewTable.getTable().getItemHeight()});
            }
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
        super.setVisible(visible);
    }

    private void moveBefore(Output moved) {
        int i = this.outputs.indexOf(moved);
        if (i > 0) {
            Output previous = this.outputs.get(i - 1);
            moved.enabledButton.moveAbove((Control)previous.enabledButton);
            moved.nameLabel.moveBelow((Control)moved.enabledButton);
            moved.upButton.moveBelow((Control)moved.nameLabel);
            moved.downButton.moveBelow((Control)moved.upButton);
            this.outputs.add(i - 1, this.outputs.remove(i));
            this.outputsContainer.layout();
            this.outputsScrolledComposite.setMinSize(this.outputsContainer.computeSize((int)-1, (int)-1).x, this.outputsContainer.computeSize((int)-1, (int)-1).y - 5);
            this.container.layout();
            this.updatePreviewTable();
        }
    }

    private void moveAfter(Output moved) {
        int i = this.outputs.indexOf(moved);
        if (i + 1 < this.outputs.size()) {
            Output next = this.outputs.get(i + 1);
            moved.enabledButton.moveBelow((Control)next.downButton);
            moved.nameLabel.moveBelow((Control)moved.enabledButton);
            moved.upButton.moveBelow((Control)moved.nameLabel);
            moved.downButton.moveBelow((Control)moved.upButton);
            this.outputs.add(i + 1, this.outputs.remove(i));
            this.outputsContainer.layout();
            this.outputsScrolledComposite.setMinSize(this.outputsContainer.computeSize((int)-1, (int)-1).x, this.outputsContainer.computeSize((int)-1, (int)-1).y - 5);
            this.container.layout();
            this.updatePreviewTable();
        }
    }

    private void updatePreviewTable() {
        int CACHE_SIZE = 50;
        this.definition.outputs = this.extractOutputs();
        this.tmpFile = Activator.getDefault().getStateLocation().addTrailingSeparator().append("customwizard.tmp").toFile();
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (FileWriter writer = new FileWriter(this.tmpFile);){
                writer.write(this.wizard.inputPage.getInputText());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error creating CustomTxtTrace. File:" + this.tmpFile.getAbsolutePath(), e);
        }
        try {
            CustomTxtTrace trace = new CustomTxtTrace(null, this.definition, this.tmpFile.getAbsolutePath(), 50){

                protected ITmfTraceIndexer createIndexer(int interval) {
                    return new TmfCheckpointIndexer((ITmfTrace)this, interval);
                }
            };
            trace.getIndexer().buildIndex(0L, TmfTimeRange.ETERNITY, false);
            this.previewTable.dispose();
            this.previewTable = new TmfEventsTable(this.tableContainer, 50, CustomEventAspects.generateAspects((CustomTraceDefinition)this.definition));
            this.previewTable.setLayoutData(new GridData(4, 4, true, true));
            this.previewTable.setTrace((ITmfTrace)trace, true);
        }
        catch (TmfTraceException e) {
            Activator.getDefault().logError("Error creating CustomTxtTrace. File:" + this.tmpFile.getAbsolutePath(), e);
        }
        this.tableContainer.layout();
        this.container.layout();
    }

    public List<CustomTraceDefinition.OutputColumn> extractOutputs() {
        int numColumns = 0;
        int i = 0;
        while (i < this.outputs.size()) {
            if (this.outputs.get((int)i).enabledButton.getSelection()) {
                ++numColumns;
            }
            ++i;
        }
        ArrayList<CustomTraceDefinition.OutputColumn> outputColumns = new ArrayList<CustomTraceDefinition.OutputColumn>(numColumns);
        numColumns = 0;
        int i2 = 0;
        while (i2 < this.outputs.size()) {
            Output output = this.outputs.get(i2);
            if (output.enabledButton.getSelection()) {
                CustomTraceDefinition.OutputColumn column = new CustomTraceDefinition.OutputColumn();
                column.name = output.nameLabel.getText();
                outputColumns.add(column);
            }
            ++i2;
        }
        return outputColumns;
    }

    public CustomTxtTraceDefinition getDefinition() {
        return this.definition;
    }

    private class Output {
        String name;
        Button enabledButton;
        Text nameLabel;
        Button upButton;
        Button downButton;

        public Output(Composite parent, String name) {
            this.name = name;
            this.enabledButton = new Button(parent, 32);
            this.enabledButton.setToolTipText(Messages.CustomTxtParserOutputWizardPage_visible);
            this.enabledButton.setSelection(true);
            this.enabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomTxtParserOutputWizardPage.this.updatePreviewTable();
                }
            });
            this.nameLabel = new Text(parent, 2060);
            this.nameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.nameLabel.setText(name);
            this.nameLabel.moveBelow((Control)this.enabledButton);
            this.upButton = new Button(parent, 8);
            this.upButton.setImage(UP_IMAGE);
            this.upButton.setToolTipText(Messages.CustomTxtParserOutputWizardPage_moveBefore);
            this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomTxtParserOutputWizardPage.this.moveBefore(Output.this);
                }
            });
            this.upButton.moveBelow((Control)this.nameLabel);
            this.downButton = new Button(parent, 8);
            this.downButton.setImage(DOWN_IMAGE);
            this.downButton.setToolTipText(Messages.CustomTxtParserOutputWizardPage_moveAfter);
            this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomTxtParserOutputWizardPage.this.moveAfter(Output.this);
                }
            });
            this.downButton.moveBelow((Control)this.upButton);
        }

        private void dispose() {
            this.enabledButton.dispose();
            this.nameLabel.dispose();
            this.upButton.dispose();
            this.downButton.dispose();
        }
    }
}

